/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.dataformat.xml;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.regex.Pattern;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.dataformat.xml.XmlNameProcessor;

public final class XmlNameProcessors {
    private XmlNameProcessors() {
    }

    public static XmlNameProcessor newPassthroughProcessor() {
        return new PassthroughProcessor();
    }

    public static XmlNameProcessor newReplacementProcessor(String string) {
        return new ReplaceNameProcessor(string);
    }

    public static XmlNameProcessor newReplacementProcessor() {
        return XmlNameProcessors.newReplacementProcessor("_");
    }

    public static XmlNameProcessor newBase64Processor(String string) {
        return new Base64NameProcessor(string);
    }

    public static XmlNameProcessor newBase64Processor() {
        return XmlNameProcessors.newBase64Processor("base64_tag_");
    }

    public static XmlNameProcessor newAlwaysOnBase64Processor() {
        return new AlwaysOnBase64NameProcessor();
    }

    static class AlwaysOnBase64NameProcessor
    implements XmlNameProcessor {
        private static final long serialVersionUID = 1L;
        private static final Base64.Decoder BASE64_DECODER = Base64.getUrlDecoder();
        private static final Base64.Encoder BASE64_ENCODER = Base64.getUrlEncoder().withoutPadding();

        @Override
        public void encodeName(XmlNameProcessor.XmlName xmlName) {
            xmlName.localPart = new String(BASE64_ENCODER.encode(xmlName.localPart.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
        }

        @Override
        public void decodeName(XmlNameProcessor.XmlName xmlName) {
            xmlName.localPart = new String(BASE64_DECODER.decode(xmlName.localPart), StandardCharsets.UTF_8);
        }
    }

    static class Base64NameProcessor
    implements XmlNameProcessor {
        private static final long serialVersionUID = 1L;
        private static final Base64.Decoder BASE64_DECODER = Base64.getUrlDecoder();
        private static final Base64.Encoder BASE64_ENCODER = Base64.getUrlEncoder().withoutPadding();
        private static final Pattern VALID_XML_NAME = Pattern.compile("[a-zA-Z_:]([a-zA-Z0-9_:.-])*");
        private final String _prefix;

        public Base64NameProcessor(String string) {
            this._prefix = string;
        }

        @Override
        public void encodeName(XmlNameProcessor.XmlName xmlName) {
            if (!VALID_XML_NAME.matcher(xmlName.localPart).matches()) {
                xmlName.localPart = this._prefix + new String(BASE64_ENCODER.encode(xmlName.localPart.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
            }
        }

        @Override
        public void decodeName(XmlNameProcessor.XmlName xmlName) {
            if (xmlName.localPart.startsWith(this._prefix)) {
                String string = xmlName.localPart;
                string = string.substring(this._prefix.length());
                xmlName.localPart = new String(BASE64_DECODER.decode(string), StandardCharsets.UTF_8);
            }
        }
    }

    static class ReplaceNameProcessor
    implements XmlNameProcessor {
        private static final long serialVersionUID = 1L;
        private static final Pattern BEGIN_MATCHER = Pattern.compile("^[^a-zA-Z_:]");
        private static final Pattern MAIN_MATCHER = Pattern.compile("[^a-zA-Z0-9_:-]");
        private final String _replacement;

        public ReplaceNameProcessor(String string) {
            this._replacement = string;
        }

        @Override
        public void encodeName(XmlNameProcessor.XmlName xmlName) {
            String string = xmlName.localPart;
            string = BEGIN_MATCHER.matcher(string).replaceAll(this._replacement);
            xmlName.localPart = MAIN_MATCHER.matcher(string).replaceAll(this._replacement);
        }

        @Override
        public void decodeName(XmlNameProcessor.XmlName xmlName) {
        }
    }

    static class PassthroughProcessor
    implements XmlNameProcessor {
        private static final long serialVersionUID = 1L;

        @Override
        public void encodeName(XmlNameProcessor.XmlName xmlName) {
        }

        @Override
        public void decodeName(XmlNameProcessor.XmlName xmlName) {
        }
    }
}

