/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.AnnotationIntrospector;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.DeserializationConfig;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.EnumNamingStrategy;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.MapperFeature;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.util.ClassUtil;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.util.CompactStringObjectMap;

public class EnumResolver
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final Class<Enum<?>> _enumClass;
    protected final Enum<?>[] _enums;
    protected final HashMap<String, Enum<?>> _enumsById;
    protected final Enum<?> _defaultValue;
    protected final boolean _isIgnoreCase;
    protected final boolean _isFromIntValue;

    protected EnumResolver(Class<Enum<?>> clazz, Enum<?>[] enumArray, HashMap<String, Enum<?>> hashMap, Enum<?> enum_, boolean bl2, boolean bl3) {
        this._enumClass = clazz;
        this._enums = enumArray;
        this._enumsById = hashMap;
        this._defaultValue = enum_;
        this._isIgnoreCase = bl2;
        this._isFromIntValue = bl3;
    }

    public static EnumResolver constructFor(DeserializationConfig deserializationConfig, AnnotatedClass annotatedClass) {
        AnnotationIntrospector annotationIntrospector = deserializationConfig.getAnnotationIntrospector();
        boolean bl2 = deserializationConfig.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS);
        Class<?> clazz = annotatedClass.getRawType();
        Class<Enum<?>> clazz2 = EnumResolver._enumClass(clazz);
        Enum<?>[] enumArray = EnumResolver._enumConstants(clazz);
        String[] stringArray = annotationIntrospector.findEnumValues(deserializationConfig, annotatedClass, enumArray, new String[enumArray.length]);
        String[][] stringArray2 = new String[stringArray.length][];
        annotationIntrospector.findEnumAliases(deserializationConfig, annotatedClass, enumArray, stringArray2);
        HashMap hashMap = new HashMap();
        int n2 = enumArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Enum<?> enum_ = enumArray[i2];
            String string = stringArray[i2];
            if (string == null) {
                string = enum_.name();
            }
            hashMap.put(string, enum_);
            String[] stringArray3 = stringArray2[i2];
            if (stringArray3 == null) continue;
            for (String string2 : stringArray3) {
                hashMap.putIfAbsent(string2, enum_);
            }
        }
        return new EnumResolver(clazz2, enumArray, hashMap, EnumResolver._enumDefault(annotationIntrospector, annotatedClass, enumArray), bl2, false);
    }

    @Deprecated
    public static EnumResolver constructFor(DeserializationConfig deserializationConfig, Class<?> clazz) {
        AnnotationIntrospector annotationIntrospector = deserializationConfig.getAnnotationIntrospector();
        boolean bl2 = deserializationConfig.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS);
        Class<Enum<?>> clazz2 = EnumResolver._enumClass(clazz);
        Enum<?>[] enumArray = EnumResolver._enumConstants(clazz);
        String[] stringArray = annotationIntrospector.findEnumValues(clazz2, enumArray, new String[enumArray.length]);
        String[][] stringArray2 = new String[stringArray.length][];
        annotationIntrospector.findEnumAliases(clazz2, enumArray, stringArray2);
        HashMap hashMap = new HashMap();
        int n2 = enumArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Enum<?> enum_ = enumArray[i2];
            String string = stringArray[i2];
            if (string == null) {
                string = enum_.name();
            }
            hashMap.put(string, enum_);
            String[] stringArray3 = stringArray2[i2];
            if (stringArray3 == null) continue;
            for (String string2 : stringArray3) {
                hashMap.putIfAbsent(string2, enum_);
            }
        }
        return new EnumResolver(clazz2, enumArray, hashMap, EnumResolver._enumDefault(annotationIntrospector, clazz2), bl2, false);
    }

    public static EnumResolver constructUsingToString(DeserializationConfig deserializationConfig, AnnotatedClass annotatedClass) {
        AnnotationIntrospector annotationIntrospector = deserializationConfig.getAnnotationIntrospector();
        boolean bl2 = deserializationConfig.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS);
        Class<?> clazz = annotatedClass.getRawType();
        Class<Enum<?>> clazz2 = EnumResolver._enumClass(clazz);
        Enum<?>[] enumArray = EnumResolver._enumConstants(clazz);
        String[] stringArray = new String[enumArray.length];
        String[][] stringArray2 = new String[enumArray.length][];
        if (annotationIntrospector != null) {
            annotationIntrospector.findEnumValues(deserializationConfig, annotatedClass, enumArray, stringArray);
            annotationIntrospector.findEnumAliases(deserializationConfig, annotatedClass, enumArray, stringArray2);
        }
        HashMap hashMap = new HashMap();
        int n2 = enumArray.length;
        while (--n2 >= 0) {
            Enum<?> enum_ = enumArray[n2];
            String string = stringArray[n2];
            if (string == null) {
                string = enum_.toString();
            }
            hashMap.put(string, enum_);
            String[] stringArray3 = stringArray2[n2];
            if (stringArray3 == null) continue;
            for (String string2 : stringArray3) {
                hashMap.putIfAbsent(string2, enum_);
            }
        }
        return new EnumResolver(clazz2, enumArray, hashMap, EnumResolver._enumDefault(annotationIntrospector, annotatedClass, enumArray), bl2, false);
    }

    @Deprecated
    public static EnumResolver constructUsingToString(DeserializationConfig deserializationConfig, Class<?> clazz) {
        AnnotationIntrospector annotationIntrospector = deserializationConfig.getAnnotationIntrospector();
        boolean bl2 = deserializationConfig.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS);
        Class<Enum<?>> clazz2 = EnumResolver._enumClass(clazz);
        Enum<?>[] enumArray = EnumResolver._enumConstants(clazz);
        HashMap hashMap = new HashMap();
        String[][] stringArray = new String[enumArray.length][];
        if (annotationIntrospector != null) {
            annotationIntrospector.findEnumAliases(clazz2, enumArray, stringArray);
        }
        int n2 = enumArray.length;
        while (--n2 >= 0) {
            Enum<?> enum_ = enumArray[n2];
            hashMap.put(enum_.toString(), enum_);
            String[] stringArray2 = stringArray[n2];
            if (stringArray2 == null) continue;
            for (String string : stringArray2) {
                hashMap.putIfAbsent(string, enum_);
            }
        }
        return new EnumResolver(clazz2, enumArray, hashMap, EnumResolver._enumDefault(annotationIntrospector, clazz2), bl2, false);
    }

    public static EnumResolver constructUsingIndex(DeserializationConfig deserializationConfig, AnnotatedClass annotatedClass) {
        AnnotationIntrospector annotationIntrospector = deserializationConfig.getAnnotationIntrospector();
        boolean bl2 = deserializationConfig.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS);
        Class<?> clazz = annotatedClass.getRawType();
        Class<Enum<?>> clazz2 = EnumResolver._enumClass(clazz);
        Enum<?>[] enumArray = EnumResolver._enumConstants(clazz);
        HashMap hashMap = new HashMap();
        int n2 = enumArray.length;
        while (--n2 >= 0) {
            Enum<?> enum_ = enumArray[n2];
            hashMap.put(String.valueOf(n2), enum_);
        }
        return new EnumResolver(clazz2, enumArray, hashMap, EnumResolver._enumDefault(annotationIntrospector, annotatedClass, enumArray), bl2, false);
    }

    @Deprecated
    public static EnumResolver constructUsingIndex(DeserializationConfig deserializationConfig, Class<Enum<?>> clazz) {
        AnnotationIntrospector annotationIntrospector = deserializationConfig.getAnnotationIntrospector();
        boolean bl2 = deserializationConfig.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS);
        Class<Enum<?>> clazz2 = EnumResolver._enumClass(clazz);
        Enum<?>[] enumArray = EnumResolver._enumConstants(clazz);
        HashMap hashMap = new HashMap();
        int n2 = enumArray.length;
        while (--n2 >= 0) {
            Enum<?> enum_ = enumArray[n2];
            hashMap.put(String.valueOf(n2), enum_);
        }
        return new EnumResolver(clazz2, enumArray, hashMap, EnumResolver._enumDefault(annotationIntrospector, clazz2), bl2, false);
    }

    @Deprecated
    public static EnumResolver constructUsingEnumNamingStrategy(DeserializationConfig deserializationConfig, Class<?> clazz, EnumNamingStrategy enumNamingStrategy) {
        AnnotationIntrospector annotationIntrospector = deserializationConfig.getAnnotationIntrospector();
        boolean bl2 = deserializationConfig.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS);
        Class<Enum<?>> clazz2 = EnumResolver._enumClass(clazz);
        Enum<?>[] enumArray = EnumResolver._enumConstants(clazz);
        HashMap hashMap = new HashMap();
        String[] stringArray = new String[enumArray.length];
        String[][] stringArray2 = new String[enumArray.length][];
        if (annotationIntrospector != null) {
            annotationIntrospector.findEnumValues(clazz2, enumArray, stringArray);
            annotationIntrospector.findEnumAliases(clazz2, enumArray, stringArray2);
        }
        int n2 = enumArray.length;
        while (--n2 >= 0) {
            Enum<?> enum_ = enumArray[n2];
            String string = stringArray[n2];
            if (string == null) {
                string = enumNamingStrategy.convertEnumToExternalName(enum_.name());
            }
            hashMap.put(string, enum_);
            String[] stringArray3 = stringArray2[n2];
            if (stringArray3 == null) continue;
            for (String string2 : stringArray3) {
                hashMap.putIfAbsent(string2, enum_);
            }
        }
        return new EnumResolver(clazz2, enumArray, hashMap, EnumResolver._enumDefault(annotationIntrospector, clazz2), bl2, false);
    }

    public static EnumResolver constructUsingEnumNamingStrategy(DeserializationConfig deserializationConfig, AnnotatedClass annotatedClass, EnumNamingStrategy enumNamingStrategy) {
        AnnotationIntrospector annotationIntrospector = deserializationConfig.getAnnotationIntrospector();
        boolean bl2 = deserializationConfig.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS);
        Class<?> clazz = annotatedClass.getRawType();
        Class<Enum<?>> clazz2 = EnumResolver._enumClass(clazz);
        Enum<?>[] enumArray = EnumResolver._enumConstants(clazz);
        String[] stringArray = new String[enumArray.length];
        String[][] stringArray2 = new String[enumArray.length][];
        if (annotationIntrospector != null) {
            annotationIntrospector.findEnumValues(deserializationConfig, annotatedClass, enumArray, stringArray);
            annotationIntrospector.findEnumAliases(deserializationConfig, annotatedClass, enumArray, stringArray2);
        }
        HashMap hashMap = new HashMap();
        int n2 = enumArray.length;
        while (--n2 >= 0) {
            Enum<?> enum_ = enumArray[n2];
            String string = stringArray[n2];
            if (string == null) {
                string = enumNamingStrategy.convertEnumToExternalName(enum_.name());
            }
            hashMap.put(string, enum_);
            String[] stringArray3 = stringArray2[n2];
            if (stringArray3 == null) continue;
            for (String string2 : stringArray3) {
                hashMap.putIfAbsent(string2, enum_);
            }
        }
        return new EnumResolver(clazz2, enumArray, hashMap, EnumResolver._enumDefault(annotationIntrospector, annotatedClass, enumArray), bl2, false);
    }

    @Deprecated
    public static EnumResolver constructUsingMethod(DeserializationConfig deserializationConfig, Class<?> clazz, AnnotatedMember annotatedMember) {
        AnnotationIntrospector annotationIntrospector = deserializationConfig.getAnnotationIntrospector();
        boolean bl2 = deserializationConfig.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS);
        Class<Enum<?>> clazz2 = EnumResolver._enumClass(clazz);
        Enum<?>[] enumArray = EnumResolver._enumConstants(clazz);
        HashMap hashMap = new HashMap();
        int n2 = enumArray.length;
        while (--n2 >= 0) {
            Enum<?> enum_ = enumArray[n2];
            try {
                Object object = annotatedMember.getValue(enum_);
                if (object == null) continue;
                hashMap.put(object.toString(), enum_);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Failed to access @JsonValue of Enum value " + enum_ + ": " + exception.getMessage());
            }
        }
        return new EnumResolver(clazz2, enumArray, hashMap, EnumResolver._enumDefault(annotationIntrospector, clazz2), bl2, EnumResolver._isIntType(annotatedMember.getRawType()));
    }

    public static EnumResolver constructUsingMethod(DeserializationConfig deserializationConfig, AnnotatedClass annotatedClass, AnnotatedMember annotatedMember) {
        AnnotationIntrospector annotationIntrospector = deserializationConfig.getAnnotationIntrospector();
        boolean bl2 = deserializationConfig.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS);
        Class<?> clazz = annotatedClass.getRawType();
        Class<Enum<?>> clazz2 = EnumResolver._enumClass(clazz);
        Enum<?>[] enumArray = EnumResolver._enumConstants(clazz);
        HashMap hashMap = new HashMap();
        int n2 = enumArray.length;
        while (--n2 >= 0) {
            Enum<?> enum_ = enumArray[n2];
            try {
                Object object = annotatedMember.getValue(enum_);
                if (object == null) continue;
                hashMap.put(object.toString(), enum_);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Failed to access @JsonValue of Enum value " + enum_ + ": " + exception.getMessage());
            }
        }
        return new EnumResolver(clazz2, enumArray, hashMap, EnumResolver._enumDefault(annotationIntrospector, annotatedClass, enumArray), bl2, EnumResolver._isIntType(annotatedMember.getRawType()));
    }

    public CompactStringObjectMap constructLookup() {
        return CompactStringObjectMap.construct(this._enumsById);
    }

    protected static Class<Enum<?>> _enumClass(Class<?> clazz) {
        return clazz;
    }

    protected static Enum<?>[] _enumConstants(Class<?> clazz) {
        Enum<?>[] enumArray = EnumResolver._enumClass(clazz).getEnumConstants();
        if (enumArray == null) {
            throw new IllegalArgumentException("No enum constants for class " + clazz.getName());
        }
        return enumArray;
    }

    protected static Enum<?> _enumDefault(AnnotationIntrospector annotationIntrospector, AnnotatedClass annotatedClass, Enum<?>[] enumArray) {
        return annotationIntrospector != null ? annotationIntrospector.findDefaultEnumValue(annotatedClass, enumArray) : null;
    }

    @Deprecated
    protected static Enum<?> _enumDefault(AnnotationIntrospector annotationIntrospector, Class<?> clazz) {
        return annotationIntrospector != null ? annotationIntrospector.findDefaultEnumValue(EnumResolver._enumClass(clazz)) : null;
    }

    protected static boolean _isIntType(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            clazz = ClassUtil.wrapperType(clazz);
        }
        return clazz == Long.class || clazz == Integer.class || clazz == Short.class || clazz == Byte.class;
    }

    public Enum<?> findEnum(String string) {
        Enum<?> enum_ = this._enumsById.get(string);
        if (enum_ == null && this._isIgnoreCase) {
            return this._findEnumCaseInsensitive(string);
        }
        return enum_;
    }

    protected Enum<?> _findEnumCaseInsensitive(String string) {
        for (Map.Entry<String, Enum<?>> entry : this._enumsById.entrySet()) {
            if (!string.equalsIgnoreCase(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    public Enum<?> getEnum(int n2) {
        if (n2 < 0 || n2 >= this._enums.length) {
            return null;
        }
        return this._enums[n2];
    }

    public Enum<?> getDefaultValue() {
        return this._defaultValue;
    }

    public Enum<?>[] getRawEnums() {
        return this._enums;
    }

    public List<Enum<?>> getEnums() {
        ArrayList arrayList = new ArrayList(this._enums.length);
        for (Enum<?> enum_ : this._enums) {
            arrayList.add(enum_);
        }
        return arrayList;
    }

    public Collection<String> getEnumIds() {
        return this._enumsById.keySet();
    }

    public Class<Enum<?>> getEnumClass() {
        return this._enumClass;
    }

    public int lastValidIndex() {
        return this._enums.length - 1;
    }

    public boolean isFromIntValue() {
        return this._isFromIntValue;
    }
}

