/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.ser.std;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Currency;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonGenerator;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonParser;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JavaType;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonMappingException;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonNode;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.SerializerProvider;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.ser.std.ClassSerializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.ser.std.FileSerializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.ser.std.NullSerializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.ser.std.UUIDSerializer;

public class StdJdkSerializers {
    public static Collection<Map.Entry<Class<?>, Object>> all() {
        HashMap<Class<Void>, Object> hashMap = new HashMap<Class<Void>, Object>();
        hashMap.put(URL.class, new ToStringSerializer(URL.class));
        hashMap.put(URI.class, new ToStringSerializer(URI.class));
        hashMap.put(Currency.class, new ToStringSerializer(Currency.class));
        hashMap.put(UUID.class, new UUIDSerializer());
        hashMap.put(Pattern.class, new ToStringSerializer(Pattern.class));
        hashMap.put(Locale.class, new ToStringSerializer(Locale.class));
        hashMap.put(AtomicBoolean.class, AtomicBooleanSerializer.class);
        hashMap.put(AtomicInteger.class, AtomicIntegerSerializer.class);
        hashMap.put(AtomicLong.class, AtomicLongSerializer.class);
        hashMap.put(File.class, FileSerializer.class);
        hashMap.put(Class.class, ClassSerializer.class);
        hashMap.put(Void.class, NullSerializer.instance);
        hashMap.put(Void.TYPE, NullSerializer.instance);
        return hashMap.entrySet();
    }

    public static class AtomicLongSerializer
    extends StdScalarSerializer<AtomicLong> {
        public AtomicLongSerializer() {
            super(AtomicLong.class, false);
        }

        @Override
        public void serialize(AtomicLong atomicLong, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeNumber(atomicLong.get());
        }

        @Override
        @Deprecated
        public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
            return this.createSchemaNode("integer", true);
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
            this.visitIntFormat(jsonFormatVisitorWrapper, javaType, JsonParser.NumberType.LONG);
        }
    }

    public static class AtomicIntegerSerializer
    extends StdScalarSerializer<AtomicInteger> {
        public AtomicIntegerSerializer() {
            super(AtomicInteger.class, false);
        }

        @Override
        public void serialize(AtomicInteger atomicInteger, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeNumber(atomicInteger.get());
        }

        @Override
        @Deprecated
        public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
            return this.createSchemaNode("integer", true);
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
            this.visitIntFormat(jsonFormatVisitorWrapper, javaType, JsonParser.NumberType.INT);
        }
    }

    public static class AtomicBooleanSerializer
    extends StdScalarSerializer<AtomicBoolean> {
        public AtomicBooleanSerializer() {
            super(AtomicBoolean.class, false);
        }

        @Override
        public void serialize(AtomicBoolean atomicBoolean, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeBoolean(atomicBoolean.get());
        }

        @Override
        @Deprecated
        public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
            return this.createSchemaNode("boolean", true);
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
            jsonFormatVisitorWrapper.expectBooleanFormat(javaType);
        }
    }
}

