/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.node;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonGenerator;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonParser;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonToken;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.io.NumberOutput;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.SerializerProvider;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.node.NumericNode;

public class FloatNode
extends NumericNode {
    protected final float _value;

    public FloatNode(float f2) {
        this._value = f2;
    }

    public static FloatNode valueOf(float f2) {
        return new FloatNode(f2);
    }

    @Override
    public JsonToken asToken() {
        return JsonToken.VALUE_NUMBER_FLOAT;
    }

    @Override
    public JsonParser.NumberType numberType() {
        return JsonParser.NumberType.FLOAT;
    }

    @Override
    public boolean isFloatingPointNumber() {
        return true;
    }

    @Override
    public boolean isFloat() {
        return true;
    }

    @Override
    public boolean canConvertToInt() {
        return this._value >= -2.1474836E9f && this._value <= 2.1474836E9f;
    }

    @Override
    public boolean canConvertToLong() {
        return this._value >= -9.223372E18f && this._value <= 9.223372E18f;
    }

    @Override
    public boolean canConvertToExactIntegral() {
        return !Float.isNaN(this._value) && !Float.isInfinite(this._value) && this._value == (float)Math.round(this._value);
    }

    @Override
    public Number numberValue() {
        return Float.valueOf(this._value);
    }

    @Override
    public short shortValue() {
        return (short)this._value;
    }

    @Override
    public int intValue() {
        return (int)this._value;
    }

    @Override
    public long longValue() {
        return (long)this._value;
    }

    @Override
    public float floatValue() {
        return this._value;
    }

    @Override
    public double doubleValue() {
        return this._value;
    }

    @Override
    public BigDecimal decimalValue() {
        return BigDecimal.valueOf(this._value);
    }

    @Override
    public BigInteger bigIntegerValue() {
        return this.decimalValue().toBigInteger();
    }

    @Override
    public String asText() {
        return NumberOutput.toString(this._value);
    }

    @Override
    public boolean isNaN() {
        return Float.isNaN(this._value) || Float.isInfinite(this._value);
    }

    @Override
    public final void serialize(JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeNumber(this._value);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof FloatNode) {
            float f2 = ((FloatNode)object)._value;
            return Float.compare(this._value, f2) == 0;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Float.floatToIntBits(this._value);
    }
}

