/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.deser.std;

import java.io.IOException;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.annotation.JsonFormat;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonParser;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonToken;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.BeanProperty;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.DeserializationConfig;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.DeserializationContext;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.DeserializationFeature;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JavaType;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonDeserializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonMappingException;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.cfg.CoercionAction;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.cfg.CoercionInputShape;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.deser.NullValueProvider;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.deser.impl.NullsConstantProvider;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.type.LogicalType;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.util.AccessPattern;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.util.ObjectBuffer;

@JacksonStdImpl
public final class StringArrayDeserializer
extends StdDeserializer<String[]>
implements ContextualDeserializer {
    private static final long serialVersionUID = 2L;
    private static final String[] NO_STRINGS = new String[0];
    public static final StringArrayDeserializer instance = new StringArrayDeserializer();
    protected JsonDeserializer<String> _elementDeserializer;
    protected final NullValueProvider _nullProvider;
    protected final Boolean _unwrapSingle;
    protected final boolean _skipNullValues;

    public StringArrayDeserializer() {
        this(null, null, null);
    }

    protected StringArrayDeserializer(JsonDeserializer<?> jsonDeserializer, NullValueProvider nullValueProvider, Boolean bl2) {
        super(String[].class);
        this._elementDeserializer = jsonDeserializer;
        this._nullProvider = nullValueProvider;
        this._unwrapSingle = bl2;
        this._skipNullValues = NullsConstantProvider.isSkipper(nullValueProvider);
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Array;
    }

    @Override
    public Boolean supportsUpdate(DeserializationConfig deserializationConfig) {
        return Boolean.TRUE;
    }

    @Override
    public AccessPattern getEmptyAccessPattern() {
        return AccessPattern.CONSTANT;
    }

    @Override
    public Object getEmptyValue(DeserializationContext deserializationContext) throws JsonMappingException {
        return NO_STRINGS;
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) throws JsonMappingException {
        JsonDeserializer<Object> jsonDeserializer = this._elementDeserializer;
        jsonDeserializer = this.findConvertingContentDeserializer(deserializationContext, beanProperty, jsonDeserializer);
        JavaType javaType = deserializationContext.constructType(String.class);
        jsonDeserializer = jsonDeserializer == null ? deserializationContext.findContextualValueDeserializer(javaType, beanProperty) : deserializationContext.handleSecondaryContextualization(jsonDeserializer, beanProperty, javaType);
        Boolean bl2 = this.findFormatFeature(deserializationContext, beanProperty, String[].class, JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        NullValueProvider nullValueProvider = this.findContentNullProvider(deserializationContext, beanProperty, jsonDeserializer);
        if (jsonDeserializer != null && this.isDefaultDeserializer(jsonDeserializer)) {
            jsonDeserializer = null;
        }
        if (this._elementDeserializer == jsonDeserializer && Objects.equals(this._unwrapSingle, bl2) && this._nullProvider == nullValueProvider) {
            return this;
        }
        return new StringArrayDeserializer(jsonDeserializer, nullValueProvider, bl2);
    }

    @Override
    public String[] deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        String[] stringArray;
        if (!jsonParser.isExpectedStartArrayToken()) {
            return this.handleNonArray(jsonParser, deserializationContext);
        }
        if (this._elementDeserializer != null) {
            return this._deserializeCustom(jsonParser, deserializationContext, null);
        }
        ObjectBuffer objectBuffer = deserializationContext.leaseObjectBuffer();
        Object[] objectArray = objectBuffer.resetAndStart();
        int n2 = 0;
        try {
            while (true) {
                if ((stringArray = jsonParser.nextTextValue()) == null) {
                    JsonToken jsonToken = jsonParser.currentToken();
                    if (jsonToken == JsonToken.END_ARRAY) break;
                    if (jsonToken == JsonToken.VALUE_NULL) {
                        if (this._skipNullValues) continue;
                        stringArray = (String)this._nullProvider.getNullValue(deserializationContext);
                    } else {
                        stringArray = this._parseString(jsonParser, deserializationContext, this._nullProvider);
                    }
                }
                if (n2 >= objectArray.length) {
                    objectArray = objectBuffer.appendCompletedChunk(objectArray);
                    n2 = 0;
                }
                objectArray[n2++] = stringArray;
            }
        }
        catch (Exception exception) {
            throw JsonMappingException.wrapWithPath((Throwable)exception, (Object)objectArray, objectBuffer.bufferedSize() + n2);
        }
        stringArray = objectBuffer.completeAndClearBuffer(objectArray, n2, String.class);
        deserializationContext.returnObjectBuffer(objectBuffer);
        return stringArray;
    }

    protected final String[] _deserializeCustom(JsonParser jsonParser, DeserializationContext deserializationContext, String[] stringArray) throws IOException {
        String[] stringArray2;
        Object[] objectArray;
        int n2;
        ObjectBuffer objectBuffer = deserializationContext.leaseObjectBuffer();
        if (stringArray == null) {
            n2 = 0;
            objectArray = objectBuffer.resetAndStart();
        } else {
            n2 = stringArray.length;
            objectArray = objectBuffer.resetAndStart(stringArray, n2);
        }
        JsonDeserializer<String> jsonDeserializer = this._elementDeserializer;
        try {
            while (true) {
                if (jsonParser.nextTextValue() == null) {
                    JsonToken jsonToken = jsonParser.currentToken();
                    if (jsonToken == JsonToken.END_ARRAY) break;
                    if (jsonToken == JsonToken.VALUE_NULL) {
                        if (this._skipNullValues) continue;
                        stringArray2 = (String)this._nullProvider.getNullValue(deserializationContext);
                    } else {
                        stringArray2 = jsonDeserializer.deserialize(jsonParser, deserializationContext);
                    }
                } else {
                    stringArray2 = jsonDeserializer.deserialize(jsonParser, deserializationContext);
                }
                if (n2 >= objectArray.length) {
                    objectArray = objectBuffer.appendCompletedChunk(objectArray);
                    n2 = 0;
                }
                objectArray[n2++] = stringArray2;
            }
        }
        catch (Exception exception) {
            throw JsonMappingException.wrapWithPath((Throwable)exception, String.class, n2);
        }
        stringArray2 = objectBuffer.completeAndClearBuffer(objectArray, n2, String.class);
        deserializationContext.returnObjectBuffer(objectBuffer);
        return stringArray2;
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromArray(jsonParser, deserializationContext);
    }

    @Override
    public String[] deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, String[] stringArray) throws IOException {
        String[] stringArray2;
        if (!jsonParser.isExpectedStartArrayToken()) {
            String[] stringArray3 = this.handleNonArray(jsonParser, deserializationContext);
            if (stringArray3 == null) {
                return stringArray;
            }
            int n2 = stringArray.length;
            String[] stringArray4 = new String[n2 + stringArray3.length];
            System.arraycopy(stringArray, 0, stringArray4, 0, n2);
            System.arraycopy(stringArray3, 0, stringArray4, n2, stringArray3.length);
            return stringArray4;
        }
        if (this._elementDeserializer != null) {
            return this._deserializeCustom(jsonParser, deserializationContext, stringArray);
        }
        ObjectBuffer objectBuffer = deserializationContext.leaseObjectBuffer();
        int n3 = stringArray.length;
        Object[] objectArray = objectBuffer.resetAndStart(stringArray, n3);
        try {
            while (true) {
                if ((stringArray2 = jsonParser.nextTextValue()) == null) {
                    JsonToken jsonToken = jsonParser.currentToken();
                    if (jsonToken == JsonToken.END_ARRAY) break;
                    if (jsonToken == JsonToken.VALUE_NULL) {
                        if (this._skipNullValues) {
                            return NO_STRINGS;
                        }
                        stringArray2 = (String)this._nullProvider.getNullValue(deserializationContext);
                    } else {
                        stringArray2 = this._parseString(jsonParser, deserializationContext, this._nullProvider);
                    }
                }
                if (n3 >= objectArray.length) {
                    objectArray = objectBuffer.appendCompletedChunk(objectArray);
                    n3 = 0;
                }
                objectArray[n3++] = stringArray2;
            }
        }
        catch (Exception exception) {
            throw JsonMappingException.wrapWithPath((Throwable)exception, (Object)objectArray, objectBuffer.bufferedSize() + n3);
        }
        stringArray2 = objectBuffer.completeAndClearBuffer(objectArray, n3, String.class);
        deserializationContext.returnObjectBuffer(objectBuffer);
        return stringArray2;
    }

    private final String[] handleNonArray(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        boolean bl2;
        boolean bl3 = bl2 = this._unwrapSingle == Boolean.TRUE || this._unwrapSingle == null && deserializationContext.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        if (bl2) {
            String string;
            if (jsonParser.hasToken(JsonToken.VALUE_NULL)) {
                string = (String)this._nullProvider.getNullValue(deserializationContext);
            } else {
                if (jsonParser.hasToken(JsonToken.VALUE_STRING)) {
                    CoercionAction coercionAction;
                    String string2 = jsonParser.getText();
                    if (string2.isEmpty()) {
                        CoercionAction coercionAction2 = deserializationContext.findCoercionAction(this.logicalType(), this.handledType(), CoercionInputShape.EmptyString);
                        if (coercionAction2 != CoercionAction.Fail) {
                            return (String[])this._deserializeFromEmptyString(jsonParser, deserializationContext, coercionAction2, this.handledType(), "empty String (\"\")");
                        }
                    } else if (StringArrayDeserializer._isBlank(string2) && (coercionAction = deserializationContext.findCoercionFromBlankString(this.logicalType(), this.handledType(), CoercionAction.Fail)) != CoercionAction.Fail) {
                        return (String[])this._deserializeFromEmptyString(jsonParser, deserializationContext, coercionAction, this.handledType(), "blank String (all whitespace)");
                    }
                }
                string = this._parseString(jsonParser, deserializationContext, this._nullProvider);
            }
            return new String[]{string};
        }
        if (jsonParser.hasToken(JsonToken.VALUE_STRING)) {
            return (String[])this._deserializeFromString(jsonParser, deserializationContext);
        }
        return (String[])deserializationContext.handleUnexpectedToken(this._valueClass, jsonParser);
    }
}

