/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.cfg;

import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.DeserializationConfig;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JavaType;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonDeserializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonSerializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.SerializationConfig;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.cfg.CacheProvider;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.util.LRUMap;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.util.LookupCache;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.util.TypeKey;

public class DefaultCacheProvider
implements CacheProvider {
    private static final long serialVersionUID = 1L;
    private static final DefaultCacheProvider DEFAULT = new DefaultCacheProvider(2000, 4000, 200);
    protected final int _maxDeserializerCacheSize;
    protected final int _maxSerializerCacheSize;
    protected final int _maxTypeFactoryCacheSize;

    protected DefaultCacheProvider(int n2, int n3, int n4) {
        this._maxDeserializerCacheSize = n2;
        this._maxSerializerCacheSize = n3;
        this._maxTypeFactoryCacheSize = n4;
    }

    public static CacheProvider defaultInstance() {
        return DEFAULT;
    }

    @Override
    public LookupCache<JavaType, JsonDeserializer<Object>> forDeserializerCache(DeserializationConfig deserializationConfig) {
        return this._buildCache(this._maxDeserializerCacheSize);
    }

    @Override
    public LookupCache<TypeKey, JsonSerializer<Object>> forSerializerCache(SerializationConfig serializationConfig) {
        return this._buildCache(this._maxSerializerCacheSize);
    }

    @Override
    public LookupCache<Object, JavaType> forTypeFactory() {
        return this._buildCache(this._maxTypeFactoryCacheSize);
    }

    protected <K, V> LookupCache<K, V> _buildCache(int n2) {
        int n3 = Math.min(64, n2 >> 2);
        return new LRUMap(n3, n2);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int _maxDeserializerCacheSize;
        private int _maxSerializerCacheSize;
        private int _maxTypeFactoryCacheSize;

        Builder() {
        }

        public Builder maxDeserializerCacheSize(int n2) {
            if (n2 < 0) {
                throw new IllegalArgumentException("Cannot set maxDeserializerCacheSize to a negative value");
            }
            this._maxDeserializerCacheSize = n2;
            return this;
        }

        public Builder maxSerializerCacheSize(int n2) {
            if (n2 < 0) {
                throw new IllegalArgumentException("Cannot set maxSerializerCacheSize to a negative value");
            }
            this._maxSerializerCacheSize = n2;
            return this;
        }

        public Builder maxTypeFactoryCacheSize(int n2) {
            if (n2 < 0) {
                throw new IllegalArgumentException("Cannot set maxTypeFactoryCacheSize to a negative value");
            }
            this._maxTypeFactoryCacheSize = n2;
            return this;
        }

        public DefaultCacheProvider build() {
            return new DefaultCacheProvider(this._maxDeserializerCacheSize, this._maxSerializerCacheSize, this._maxTypeFactoryCacheSize);
        }
    }
}

