/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind;

import java.io.Closeable;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.Base64Variant;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.FormatFeature;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.FormatSchema;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonEncoding;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonFactory;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonGenerator;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonParser;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonProcessingException;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.PrettyPrinter;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.SerializableString;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.StreamWriteFeature;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.Version;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.Versioned;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.exc.StreamWriteException;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.io.CharacterEscapes;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.io.SerializedString;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.type.TypeReference;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.util.Instantiatable;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.util.MinimalPrettyPrinter;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.DatabindException;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JavaType;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonMappingException;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonSerializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.MapperFeature;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.ObjectMapper;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.PropertyName;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.RuntimeJsonMappingException;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.SequenceWriter;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.SerializationConfig;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.SerializationFeature;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.cfg.ContextAttributes;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.cfg.DatatypeFeature;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.cfg.PackageVersion;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.ser.FilterProvider;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.ser.SerializerFactory;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.ser.impl.TypeWrappedSerializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.type.TypeFactory;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.util.ClassUtil;

public class ObjectWriter
implements Versioned,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final PrettyPrinter NULL_PRETTY_PRINTER = new MinimalPrettyPrinter();
    protected final SerializationConfig _config;
    protected final DefaultSerializerProvider _serializerProvider;
    protected final SerializerFactory _serializerFactory;
    protected final JsonFactory _generatorFactory;
    protected final GeneratorSettings _generatorSettings;
    protected final Prefetch _prefetch;

    protected ObjectWriter(ObjectMapper objectMapper, SerializationConfig serializationConfig, JavaType javaType, PrettyPrinter prettyPrinter) {
        this._config = serializationConfig;
        this._serializerProvider = objectMapper._serializerProvider;
        this._serializerFactory = objectMapper._serializerFactory;
        this._generatorFactory = objectMapper._jsonFactory;
        GeneratorSettings generatorSettings = this._generatorSettings = prettyPrinter == null ? GeneratorSettings.empty : new GeneratorSettings(prettyPrinter, null, null, null);
        this._prefetch = javaType == null ? Prefetch.empty : (javaType.hasRawClass(Object.class) ? Prefetch.empty.forRootType(this, javaType) : Prefetch.empty.forRootType(this, javaType.withStaticTyping()));
    }

    protected ObjectWriter(ObjectMapper objectMapper, SerializationConfig serializationConfig) {
        this._config = serializationConfig;
        this._serializerProvider = objectMapper._serializerProvider;
        this._serializerFactory = objectMapper._serializerFactory;
        this._generatorFactory = objectMapper._jsonFactory;
        this._generatorSettings = GeneratorSettings.empty;
        this._prefetch = Prefetch.empty;
    }

    protected ObjectWriter(ObjectMapper objectMapper, SerializationConfig serializationConfig, FormatSchema formatSchema) {
        this._config = serializationConfig;
        this._serializerProvider = objectMapper._serializerProvider;
        this._serializerFactory = objectMapper._serializerFactory;
        this._generatorFactory = objectMapper._jsonFactory;
        this._generatorSettings = formatSchema == null ? GeneratorSettings.empty : new GeneratorSettings(null, formatSchema, null, null);
        this._prefetch = Prefetch.empty;
    }

    protected ObjectWriter(ObjectWriter objectWriter, SerializationConfig serializationConfig, GeneratorSettings generatorSettings, Prefetch prefetch) {
        this._config = serializationConfig;
        this._serializerProvider = objectWriter._serializerProvider;
        this._serializerFactory = objectWriter._serializerFactory;
        this._generatorFactory = objectWriter._generatorFactory;
        this._generatorSettings = generatorSettings;
        this._prefetch = prefetch;
    }

    protected ObjectWriter(ObjectWriter objectWriter, SerializationConfig serializationConfig) {
        this._config = serializationConfig;
        this._serializerProvider = objectWriter._serializerProvider;
        this._serializerFactory = objectWriter._serializerFactory;
        this._generatorFactory = objectWriter._generatorFactory;
        this._generatorSettings = objectWriter._generatorSettings;
        this._prefetch = objectWriter._prefetch;
    }

    protected ObjectWriter(ObjectWriter objectWriter, JsonFactory jsonFactory) {
        this._config = (SerializationConfig)objectWriter._config.with(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, jsonFactory.requiresPropertyOrdering());
        this._serializerProvider = objectWriter._serializerProvider;
        this._serializerFactory = objectWriter._serializerFactory;
        this._generatorFactory = jsonFactory;
        this._generatorSettings = objectWriter._generatorSettings;
        this._prefetch = objectWriter._prefetch;
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    protected ObjectWriter _new(ObjectWriter objectWriter, JsonFactory jsonFactory) {
        return new ObjectWriter(objectWriter, jsonFactory);
    }

    protected ObjectWriter _new(ObjectWriter objectWriter, SerializationConfig serializationConfig) {
        if (serializationConfig == this._config) {
            return this;
        }
        return new ObjectWriter(objectWriter, serializationConfig);
    }

    protected ObjectWriter _new(GeneratorSettings generatorSettings, Prefetch prefetch) {
        if (this._generatorSettings == generatorSettings && this._prefetch == prefetch) {
            return this;
        }
        return new ObjectWriter(this, this._config, generatorSettings, prefetch);
    }

    protected SequenceWriter _newSequenceWriter(boolean bl2, JsonGenerator jsonGenerator, boolean bl3) throws IOException {
        return new SequenceWriter(this._serializerProvider(), this._configureGenerator(jsonGenerator), bl3, this._prefetch).init(bl2);
    }

    public ObjectWriter with(SerializationFeature serializationFeature) {
        return this._new(this, this._config.with(serializationFeature));
    }

    public ObjectWriter with(SerializationFeature serializationFeature, SerializationFeature ... serializationFeatureArray) {
        return this._new(this, this._config.with(serializationFeature, serializationFeatureArray));
    }

    public ObjectWriter withFeatures(SerializationFeature ... serializationFeatureArray) {
        return this._new(this, this._config.withFeatures(serializationFeatureArray));
    }

    public ObjectWriter without(SerializationFeature serializationFeature) {
        return this._new(this, this._config.without(serializationFeature));
    }

    public ObjectWriter without(SerializationFeature serializationFeature, SerializationFeature ... serializationFeatureArray) {
        return this._new(this, this._config.without(serializationFeature, serializationFeatureArray));
    }

    public ObjectWriter withoutFeatures(SerializationFeature ... serializationFeatureArray) {
        return this._new(this, this._config.withoutFeatures(serializationFeatureArray));
    }

    public ObjectWriter with(DatatypeFeature datatypeFeature) {
        return this._new(this, (SerializationConfig)this._config.with(datatypeFeature));
    }

    public ObjectWriter withFeatures(DatatypeFeature ... datatypeFeatureArray) {
        return this._new(this, (SerializationConfig)this._config.withFeatures(datatypeFeatureArray));
    }

    public ObjectWriter without(DatatypeFeature datatypeFeature) {
        return this._new(this, (SerializationConfig)this._config.without(datatypeFeature));
    }

    public ObjectWriter withoutFeatures(DatatypeFeature ... datatypeFeatureArray) {
        return this._new(this, (SerializationConfig)this._config.withoutFeatures(datatypeFeatureArray));
    }

    public ObjectWriter with(JsonGenerator.Feature feature) {
        return this._new(this, this._config.with(feature));
    }

    public ObjectWriter withFeatures(JsonGenerator.Feature ... featureArray) {
        return this._new(this, this._config.withFeatures(featureArray));
    }

    public ObjectWriter without(JsonGenerator.Feature feature) {
        return this._new(this, this._config.without(feature));
    }

    public ObjectWriter withoutFeatures(JsonGenerator.Feature ... featureArray) {
        return this._new(this, this._config.withoutFeatures(featureArray));
    }

    public ObjectWriter with(StreamWriteFeature streamWriteFeature) {
        return this._new(this, this._config.with(streamWriteFeature.mappedFeature()));
    }

    public ObjectWriter without(StreamWriteFeature streamWriteFeature) {
        return this._new(this, this._config.without(streamWriteFeature.mappedFeature()));
    }

    public ObjectWriter with(FormatFeature formatFeature) {
        return this._new(this, this._config.with(formatFeature));
    }

    public ObjectWriter withFeatures(FormatFeature ... formatFeatureArray) {
        return this._new(this, this._config.withFeatures(formatFeatureArray));
    }

    public ObjectWriter without(FormatFeature formatFeature) {
        return this._new(this, this._config.without(formatFeature));
    }

    public ObjectWriter withoutFeatures(FormatFeature ... formatFeatureArray) {
        return this._new(this, this._config.withoutFeatures(formatFeatureArray));
    }

    public ObjectWriter forType(JavaType javaType) {
        return this._new(this._generatorSettings, this._prefetch.forRootType(this, javaType));
    }

    public ObjectWriter forType(Class<?> clazz) {
        return this.forType(this._config.constructType(clazz));
    }

    public ObjectWriter forType(TypeReference<?> typeReference) {
        return this.forType(this._config.getTypeFactory().constructType(typeReference.getType()));
    }

    @Deprecated
    public ObjectWriter withType(JavaType javaType) {
        return this.forType(javaType);
    }

    @Deprecated
    public ObjectWriter withType(Class<?> clazz) {
        return this.forType(clazz);
    }

    @Deprecated
    public ObjectWriter withType(TypeReference<?> typeReference) {
        return this.forType(typeReference);
    }

    public ObjectWriter with(DateFormat dateFormat) {
        return this._new(this, this._config.with(dateFormat));
    }

    public ObjectWriter withDefaultPrettyPrinter() {
        return this.with(this._config.getDefaultPrettyPrinter());
    }

    public ObjectWriter with(FilterProvider filterProvider) {
        if (filterProvider == this._config.getFilterProvider()) {
            return this;
        }
        return this._new(this, this._config.withFilters(filterProvider));
    }

    public ObjectWriter with(PrettyPrinter prettyPrinter) {
        return this._new(this._generatorSettings.with(prettyPrinter), this._prefetch);
    }

    public ObjectWriter withRootName(String string) {
        return this._new(this, (SerializationConfig)this._config.withRootName(string));
    }

    public ObjectWriter withRootName(PropertyName propertyName) {
        return this._new(this, this._config.withRootName(propertyName));
    }

    public ObjectWriter withoutRootName() {
        return this._new(this, this._config.withRootName(PropertyName.NO_NAME));
    }

    public ObjectWriter with(FormatSchema formatSchema) {
        this._verifySchemaType(formatSchema);
        return this._new(this._generatorSettings.with(formatSchema), this._prefetch);
    }

    @Deprecated
    public ObjectWriter withSchema(FormatSchema formatSchema) {
        return this.with(formatSchema);
    }

    public ObjectWriter withView(Class<?> clazz) {
        return this._new(this, (SerializationConfig)this._config.withView((Class)clazz));
    }

    public ObjectWriter with(Locale locale) {
        return this._new(this, (SerializationConfig)this._config.with(locale));
    }

    public ObjectWriter with(TimeZone timeZone) {
        return this._new(this, (SerializationConfig)this._config.with(timeZone));
    }

    public ObjectWriter with(Base64Variant base64Variant) {
        return this._new(this, (SerializationConfig)this._config.with(base64Variant));
    }

    public ObjectWriter with(CharacterEscapes characterEscapes) {
        return this._new(this._generatorSettings.with(characterEscapes), this._prefetch);
    }

    public ObjectWriter with(JsonFactory jsonFactory) {
        return jsonFactory == this._generatorFactory ? this : this._new(this, jsonFactory);
    }

    public ObjectWriter with(ContextAttributes contextAttributes) {
        return this._new(this, this._config.with(contextAttributes));
    }

    public ObjectWriter withAttributes(Map<?, ?> map) {
        return this._new(this, (SerializationConfig)this._config.withAttributes(map));
    }

    public ObjectWriter withAttribute(Object object, Object object2) {
        return this._new(this, (SerializationConfig)this._config.withAttribute(object, object2));
    }

    public ObjectWriter withoutAttribute(Object object) {
        return this._new(this, (SerializationConfig)this._config.withoutAttribute(object));
    }

    public ObjectWriter withRootValueSeparator(String string) {
        return this._new(this._generatorSettings.withRootValueSeparator(string), this._prefetch);
    }

    public ObjectWriter withRootValueSeparator(SerializableString serializableString) {
        return this._new(this._generatorSettings.withRootValueSeparator(serializableString), this._prefetch);
    }

    public JsonGenerator createGenerator(OutputStream outputStream) throws IOException {
        this._assertNotNull("out", outputStream);
        return this._configureGenerator(this._generatorFactory.createGenerator(outputStream, JsonEncoding.UTF8));
    }

    public JsonGenerator createGenerator(OutputStream outputStream, JsonEncoding jsonEncoding) throws IOException {
        this._assertNotNull("out", outputStream);
        return this._configureGenerator(this._generatorFactory.createGenerator(outputStream, jsonEncoding));
    }

    public JsonGenerator createGenerator(Writer writer) throws IOException {
        this._assertNotNull("w", writer);
        return this._configureGenerator(this._generatorFactory.createGenerator(writer));
    }

    public JsonGenerator createGenerator(File file, JsonEncoding jsonEncoding) throws IOException {
        this._assertNotNull("outputFile", file);
        return this._configureGenerator(this._generatorFactory.createGenerator(file, jsonEncoding));
    }

    public JsonGenerator createGenerator(DataOutput dataOutput) throws IOException {
        this._assertNotNull("out", dataOutput);
        return this._configureGenerator(this._generatorFactory.createGenerator(dataOutput));
    }

    public SequenceWriter writeValues(File file) throws IOException {
        return this._newSequenceWriter(false, this.createGenerator(file, JsonEncoding.UTF8), true);
    }

    public SequenceWriter writeValues(JsonGenerator jsonGenerator) throws IOException {
        this._assertNotNull("g", jsonGenerator);
        return this._newSequenceWriter(false, this._configureGenerator(jsonGenerator), false);
    }

    public SequenceWriter writeValues(Writer writer) throws IOException {
        return this._newSequenceWriter(false, this.createGenerator(writer), true);
    }

    public SequenceWriter writeValues(OutputStream outputStream) throws IOException {
        return this._newSequenceWriter(false, this.createGenerator(outputStream, JsonEncoding.UTF8), true);
    }

    public SequenceWriter writeValues(DataOutput dataOutput) throws IOException {
        return this._newSequenceWriter(false, this.createGenerator(dataOutput), true);
    }

    public SequenceWriter writeValuesAsArray(File file) throws IOException {
        return this._newSequenceWriter(true, this.createGenerator(file, JsonEncoding.UTF8), true);
    }

    public SequenceWriter writeValuesAsArray(JsonGenerator jsonGenerator) throws IOException {
        this._assertNotNull("gen", jsonGenerator);
        return this._newSequenceWriter(true, jsonGenerator, false);
    }

    public SequenceWriter writeValuesAsArray(Writer writer) throws IOException {
        return this._newSequenceWriter(true, this.createGenerator(writer), true);
    }

    public SequenceWriter writeValuesAsArray(OutputStream outputStream) throws IOException {
        return this._newSequenceWriter(true, this.createGenerator(outputStream, JsonEncoding.UTF8), true);
    }

    public SequenceWriter writeValuesAsArray(DataOutput dataOutput) throws IOException {
        return this._newSequenceWriter(true, this.createGenerator(dataOutput), true);
    }

    public boolean isEnabled(SerializationFeature serializationFeature) {
        return this._config.isEnabled(serializationFeature);
    }

    public boolean isEnabled(MapperFeature mapperFeature) {
        return this._config.isEnabled(mapperFeature);
    }

    public boolean isEnabled(DatatypeFeature datatypeFeature) {
        return this._config.isEnabled(datatypeFeature);
    }

    @Deprecated
    public boolean isEnabled(JsonParser.Feature feature) {
        return this._generatorFactory.isEnabled(feature);
    }

    public boolean isEnabled(JsonGenerator.Feature feature) {
        return this._generatorFactory.isEnabled(feature);
    }

    public boolean isEnabled(StreamWriteFeature streamWriteFeature) {
        return this._generatorFactory.isEnabled(streamWriteFeature);
    }

    public SerializationConfig getConfig() {
        return this._config;
    }

    public JsonFactory getFactory() {
        return this._generatorFactory;
    }

    public TypeFactory getTypeFactory() {
        return this._config.getTypeFactory();
    }

    public boolean hasPrefetchedSerializer() {
        return this._prefetch.hasSerializer();
    }

    public ContextAttributes getAttributes() {
        return this._config.getAttributes();
    }

    public void writeValue(JsonGenerator jsonGenerator, Object object) throws IOException {
        this._assertNotNull("g", jsonGenerator);
        this._configureGenerator(jsonGenerator);
        if (this._config.isEnabled(SerializationFeature.CLOSE_CLOSEABLE) && object instanceof Closeable) {
            Closeable closeable = (Closeable)object;
            try {
                this._prefetch.serialize(jsonGenerator, object, this._serializerProvider());
                if (this._config.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE)) {
                    jsonGenerator.flush();
                }
            }
            catch (Exception exception) {
                ClassUtil.closeOnFailAndThrowAsIOE(null, closeable, exception);
                return;
            }
            closeable.close();
        } else {
            this._prefetch.serialize(jsonGenerator, object, this._serializerProvider());
            if (this._config.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE)) {
                jsonGenerator.flush();
            }
        }
    }

    public void writeValue(File file, Object object) throws IOException, StreamWriteException, DatabindException {
        this._writeValueAndClose(this.createGenerator(file, JsonEncoding.UTF8), object);
    }

    public void writeValue(OutputStream outputStream, Object object) throws IOException, StreamWriteException, DatabindException {
        this._writeValueAndClose(this.createGenerator(outputStream, JsonEncoding.UTF8), object);
    }

    public void writeValue(Writer writer, Object object) throws IOException, StreamWriteException, DatabindException {
        this._writeValueAndClose(this.createGenerator(writer), object);
    }

    public void writeValue(DataOutput dataOutput, Object object) throws IOException, StreamWriteException, DatabindException {
        this._writeValueAndClose(this.createGenerator(dataOutput), object);
    }

    /*
     * Exception decompiling
     */
    public String writeValueAsString(Object var1_1) throws JsonProcessingException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public byte[] writeValueAsBytes(Object var1_1) throws JsonProcessingException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void acceptJsonFormatVisitor(JavaType javaType, JsonFormatVisitorWrapper jsonFormatVisitorWrapper) throws JsonMappingException {
        this._assertNotNull("type", javaType);
        this._assertNotNull("visitor", jsonFormatVisitorWrapper);
        this._serializerProvider().acceptJsonFormatVisitor(javaType, jsonFormatVisitorWrapper);
    }

    public void acceptJsonFormatVisitor(Class<?> clazz, JsonFormatVisitorWrapper jsonFormatVisitorWrapper) throws JsonMappingException {
        this._assertNotNull("type", clazz);
        this._assertNotNull("visitor", jsonFormatVisitorWrapper);
        this.acceptJsonFormatVisitor(this._config.constructType(clazz), jsonFormatVisitorWrapper);
    }

    public boolean canSerialize(Class<?> clazz) {
        this._assertNotNull("type", clazz);
        return this._serializerProvider().hasSerializerFor(clazz, null);
    }

    public boolean canSerialize(Class<?> clazz, AtomicReference<Throwable> atomicReference) {
        this._assertNotNull("type", clazz);
        return this._serializerProvider().hasSerializerFor(clazz, atomicReference);
    }

    protected DefaultSerializerProvider _serializerProvider() {
        return this._serializerProvider.createInstance(this._config, this._serializerFactory);
    }

    protected void _verifySchemaType(FormatSchema formatSchema) {
        if (formatSchema != null && !this._generatorFactory.canUseSchema(formatSchema)) {
            throw new IllegalArgumentException("Cannot use FormatSchema of type " + formatSchema.getClass().getName() + " for format " + this._generatorFactory.getFormatName());
        }
    }

    protected final void _writeValueAndClose(JsonGenerator jsonGenerator, Object object) throws IOException {
        if (this._config.isEnabled(SerializationFeature.CLOSE_CLOSEABLE) && object instanceof Closeable) {
            this._writeCloseable(jsonGenerator, object);
            return;
        }
        try {
            this._prefetch.serialize(jsonGenerator, object, this._serializerProvider());
        }
        catch (Exception exception) {
            ClassUtil.closeOnFailAndThrowAsIOE(jsonGenerator, exception);
            return;
        }
        jsonGenerator.close();
    }

    private final void _writeCloseable(JsonGenerator jsonGenerator, Object object) throws IOException {
        Closeable closeable = (Closeable)object;
        try {
            this._prefetch.serialize(jsonGenerator, object, this._serializerProvider());
            Closeable closeable2 = closeable;
            closeable = null;
            closeable2.close();
        }
        catch (Exception exception) {
            ClassUtil.closeOnFailAndThrowAsIOE(jsonGenerator, closeable, exception);
            return;
        }
        jsonGenerator.close();
    }

    protected final JsonGenerator _configureGenerator(JsonGenerator jsonGenerator) {
        this._config.initialize(jsonGenerator);
        this._generatorSettings.initialize(jsonGenerator);
        return jsonGenerator;
    }

    protected final void _assertNotNull(String string, Object object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("argument \"%s\" is null", string));
        }
    }

    public static final class Prefetch
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static final Prefetch empty = new Prefetch(null, null, null);
        private final JavaType rootType;
        private final JsonSerializer<Object> valueSerializer;
        private final TypeSerializer typeSerializer;

        private Prefetch(JavaType javaType, JsonSerializer<Object> jsonSerializer, TypeSerializer typeSerializer) {
            this.rootType = javaType;
            this.valueSerializer = jsonSerializer;
            this.typeSerializer = typeSerializer;
        }

        public Prefetch forRootType(ObjectWriter objectWriter, JavaType javaType) {
            if (javaType == null) {
                if (this.rootType == null || this.valueSerializer == null) {
                    return this;
                }
                return new Prefetch(null, null, null);
            }
            if (javaType.equals(this.rootType)) {
                return this;
            }
            if (javaType.isJavaLangObject()) {
                TypeSerializer typeSerializer;
                DefaultSerializerProvider defaultSerializerProvider = objectWriter._serializerProvider();
                try {
                    typeSerializer = defaultSerializerProvider.findTypeSerializer(javaType);
                }
                catch (JsonMappingException jsonMappingException) {
                    throw new RuntimeJsonMappingException(jsonMappingException);
                }
                return new Prefetch(null, null, typeSerializer);
            }
            if (objectWriter.isEnabled(SerializationFeature.EAGER_SERIALIZER_FETCH)) {
                DefaultSerializerProvider defaultSerializerProvider = objectWriter._serializerProvider();
                try {
                    JsonSerializer<Object> jsonSerializer = defaultSerializerProvider.findTypedValueSerializer(javaType, true, null);
                    if (jsonSerializer instanceof TypeWrappedSerializer) {
                        return new Prefetch(javaType, null, ((TypeWrappedSerializer)jsonSerializer).typeSerializer());
                    }
                    return new Prefetch(javaType, jsonSerializer, null);
                }
                catch (DatabindException databindException) {
                    // empty catch block
                }
            }
            return new Prefetch(javaType, null, this.typeSerializer);
        }

        public final JsonSerializer<Object> getValueSerializer() {
            return this.valueSerializer;
        }

        public final TypeSerializer getTypeSerializer() {
            return this.typeSerializer;
        }

        public boolean hasSerializer() {
            return this.valueSerializer != null || this.typeSerializer != null;
        }

        public void serialize(JsonGenerator jsonGenerator, Object object, DefaultSerializerProvider defaultSerializerProvider) throws IOException {
            if (this.typeSerializer != null) {
                defaultSerializerProvider.serializePolymorphic(jsonGenerator, object, this.rootType, this.valueSerializer, this.typeSerializer);
            } else if (this.valueSerializer != null) {
                defaultSerializerProvider.serializeValue(jsonGenerator, object, this.rootType, this.valueSerializer);
            } else if (this.rootType != null) {
                defaultSerializerProvider.serializeValue(jsonGenerator, object, this.rootType);
            } else {
                defaultSerializerProvider.serializeValue(jsonGenerator, object);
            }
        }
    }

    public static final class GeneratorSettings
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static final GeneratorSettings empty = new GeneratorSettings(null, null, null, null);
        public final PrettyPrinter prettyPrinter;
        public final FormatSchema schema;
        public final CharacterEscapes characterEscapes;
        public final SerializableString rootValueSeparator;

        public GeneratorSettings(PrettyPrinter prettyPrinter, FormatSchema formatSchema, CharacterEscapes characterEscapes, SerializableString serializableString) {
            this.prettyPrinter = prettyPrinter;
            this.schema = formatSchema;
            this.characterEscapes = characterEscapes;
            this.rootValueSeparator = serializableString;
        }

        public GeneratorSettings with(PrettyPrinter prettyPrinter) {
            if (prettyPrinter == null) {
                prettyPrinter = NULL_PRETTY_PRINTER;
            }
            return prettyPrinter == this.prettyPrinter ? this : new GeneratorSettings(prettyPrinter, this.schema, this.characterEscapes, this.rootValueSeparator);
        }

        public GeneratorSettings with(FormatSchema formatSchema) {
            return this.schema == formatSchema ? this : new GeneratorSettings(this.prettyPrinter, formatSchema, this.characterEscapes, this.rootValueSeparator);
        }

        public GeneratorSettings with(CharacterEscapes characterEscapes) {
            return this.characterEscapes == characterEscapes ? this : new GeneratorSettings(this.prettyPrinter, this.schema, characterEscapes, this.rootValueSeparator);
        }

        public GeneratorSettings withRootValueSeparator(String string) {
            if (string == null) {
                if (this.rootValueSeparator == null) {
                    return this;
                }
                return new GeneratorSettings(this.prettyPrinter, this.schema, this.characterEscapes, null);
            }
            if (string.equals(this._rootValueSeparatorAsString())) {
                return this;
            }
            return new GeneratorSettings(this.prettyPrinter, this.schema, this.characterEscapes, new SerializedString(string));
        }

        public GeneratorSettings withRootValueSeparator(SerializableString serializableString) {
            if (serializableString == null) {
                if (this.rootValueSeparator == null) {
                    return this;
                }
                return new GeneratorSettings(this.prettyPrinter, this.schema, this.characterEscapes, null);
            }
            if (serializableString.equals(this.rootValueSeparator)) {
                return this;
            }
            return new GeneratorSettings(this.prettyPrinter, this.schema, this.characterEscapes, serializableString);
        }

        private final String _rootValueSeparatorAsString() {
            return this.rootValueSeparator == null ? null : this.rootValueSeparator.getValue();
        }

        public void initialize(JsonGenerator jsonGenerator) {
            PrettyPrinter prettyPrinter = this.prettyPrinter;
            if (this.prettyPrinter != null) {
                if (prettyPrinter == NULL_PRETTY_PRINTER) {
                    jsonGenerator.setPrettyPrinter(null);
                } else {
                    if (prettyPrinter instanceof Instantiatable) {
                        prettyPrinter = (PrettyPrinter)((Instantiatable)((Object)prettyPrinter)).createInstance();
                    }
                    jsonGenerator.setPrettyPrinter(prettyPrinter);
                }
            }
            if (this.characterEscapes != null) {
                jsonGenerator.setCharacterEscapes(this.characterEscapes);
            }
            if (this.schema != null) {
                jsonGenerator.setSchema(this.schema);
            }
            if (this.rootValueSeparator != null) {
                jsonGenerator.setRootValueSeparator(this.rootValueSeparator);
            }
        }
    }
}

