/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.util;

import java.io.Serializable;
import java.util.Objects;

public class Separators
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_ROOT_VALUE_SEPARATOR = " ";
    public static final String DEFAULT_OBJECT_EMPTY_SEPARATOR = " ";
    public static final String DEFAULT_ARRAY_EMPTY_SEPARATOR = " ";
    private final char objectFieldValueSeparator;
    private final Spacing objectFieldValueSpacing;
    private final char objectEntrySeparator;
    private final Spacing objectEntrySpacing;
    private final String objectEmptySeparator;
    private final char arrayValueSeparator;
    private final Spacing arrayValueSpacing;
    private final String arrayEmptySeparator;
    private final String rootSeparator;

    public static Separators createDefaultInstance() {
        return new Separators();
    }

    public Separators() {
        this(':', ',', ',');
    }

    public Separators(char c2, char c3, char c4) {
        this(" ", c2, Spacing.BOTH, c3, Spacing.NONE, " ", c4, Spacing.NONE, " ");
    }

    @Deprecated
    public Separators(String string, char c2, Spacing spacing, char c3, Spacing spacing2, char c4, Spacing spacing3) {
        this(string, c2, spacing, c3, spacing2, " ", c4, spacing3, " ");
    }

    public Separators(String string, char c2, Spacing spacing, char c3, Spacing spacing2, String string2, char c4, Spacing spacing3, String string3) {
        this.rootSeparator = string;
        this.objectFieldValueSeparator = c2;
        this.objectFieldValueSpacing = spacing;
        this.objectEntrySeparator = c3;
        this.objectEntrySpacing = spacing2;
        this.objectEmptySeparator = string2;
        this.arrayValueSeparator = c4;
        this.arrayValueSpacing = spacing3;
        this.arrayEmptySeparator = string3;
    }

    public Separators withRootSeparator(String string) {
        return Objects.equals(this.rootSeparator, string) ? this : new Separators(string, this.objectFieldValueSeparator, this.objectFieldValueSpacing, this.objectEntrySeparator, this.objectEntrySpacing, this.objectEmptySeparator, this.arrayValueSeparator, this.arrayValueSpacing, this.arrayEmptySeparator);
    }

    public Separators withObjectFieldValueSeparator(char c2) {
        return this.objectFieldValueSeparator == c2 ? this : new Separators(this.rootSeparator, c2, this.objectFieldValueSpacing, this.objectEntrySeparator, this.objectEntrySpacing, this.objectEmptySeparator, this.arrayValueSeparator, this.arrayValueSpacing, this.arrayEmptySeparator);
    }

    public Separators withObjectFieldValueSpacing(Spacing spacing) {
        return this.objectFieldValueSpacing == spacing ? this : new Separators(this.rootSeparator, this.objectFieldValueSeparator, spacing, this.objectEntrySeparator, this.objectEntrySpacing, this.objectEmptySeparator, this.arrayValueSeparator, this.arrayValueSpacing, this.arrayEmptySeparator);
    }

    public Separators withObjectEntrySeparator(char c2) {
        return this.objectEntrySeparator == c2 ? this : new Separators(this.rootSeparator, this.objectFieldValueSeparator, this.objectFieldValueSpacing, c2, this.objectEntrySpacing, this.objectEmptySeparator, this.arrayValueSeparator, this.arrayValueSpacing, this.arrayEmptySeparator);
    }

    public Separators withObjectEntrySpacing(Spacing spacing) {
        return this.objectEntrySpacing == spacing ? this : new Separators(this.rootSeparator, this.objectFieldValueSeparator, this.objectFieldValueSpacing, this.objectEntrySeparator, spacing, this.objectEmptySeparator, this.arrayValueSeparator, this.arrayValueSpacing, this.arrayEmptySeparator);
    }

    public Separators withObjectEmptySeparator(String string) {
        return Objects.equals(this.objectEmptySeparator, string) ? this : new Separators(this.rootSeparator, this.objectFieldValueSeparator, this.objectFieldValueSpacing, this.objectEntrySeparator, this.objectEntrySpacing, string, this.arrayValueSeparator, this.arrayValueSpacing, this.arrayEmptySeparator);
    }

    public Separators withArrayValueSeparator(char c2) {
        return this.arrayValueSeparator == c2 ? this : new Separators(this.rootSeparator, this.objectFieldValueSeparator, this.objectFieldValueSpacing, this.objectEntrySeparator, this.objectEntrySpacing, this.objectEmptySeparator, c2, this.arrayValueSpacing, this.arrayEmptySeparator);
    }

    public Separators withArrayValueSpacing(Spacing spacing) {
        return this.arrayValueSpacing == spacing ? this : new Separators(this.rootSeparator, this.objectFieldValueSeparator, this.objectFieldValueSpacing, this.objectEntrySeparator, this.objectEntrySpacing, this.objectEmptySeparator, this.arrayValueSeparator, spacing, this.arrayEmptySeparator);
    }

    public Separators withArrayEmptySeparator(String string) {
        return Objects.equals(this.arrayEmptySeparator, string) ? this : new Separators(this.rootSeparator, this.objectFieldValueSeparator, this.objectFieldValueSpacing, this.objectEntrySeparator, this.objectEntrySpacing, this.objectEmptySeparator, this.arrayValueSeparator, this.arrayValueSpacing, string);
    }

    public String getRootSeparator() {
        return this.rootSeparator;
    }

    public char getObjectFieldValueSeparator() {
        return this.objectFieldValueSeparator;
    }

    public Spacing getObjectFieldValueSpacing() {
        return this.objectFieldValueSpacing;
    }

    public char getObjectEntrySeparator() {
        return this.objectEntrySeparator;
    }

    public Spacing getObjectEntrySpacing() {
        return this.objectEntrySpacing;
    }

    public String getObjectEmptySeparator() {
        return this.objectEmptySeparator;
    }

    public char getArrayValueSeparator() {
        return this.arrayValueSeparator;
    }

    public Spacing getArrayValueSpacing() {
        return this.arrayValueSpacing;
    }

    public String getArrayEmptySeparator() {
        return this.arrayEmptySeparator;
    }

    public static enum Spacing {
        NONE("", ""),
        BEFORE(" ", ""),
        AFTER("", " "),
        BOTH(" ", " ");

        private final String spacesBefore;
        private final String spacesAfter;

        private Spacing(String string2, String string3) {
            this.spacesBefore = string2;
            this.spacesAfter = string3;
        }

        public String spacesBefore() {
            return this.spacesBefore;
        }

        public String spacesAfter() {
            return this.spacesAfter;
        }

        public String apply(char c2) {
            return this.spacesBefore + c2 + this.spacesAfter;
        }
    }
}

