/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.io.doubleparser;

import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.io.doubleparser.JavaDoubleBitsFromByteArray;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.io.doubleparser.JavaDoubleBitsFromCharArray;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.io.doubleparser.JavaDoubleBitsFromCharSequence;

public class JavaDoubleParser {
    private static final JavaDoubleBitsFromByteArray BYTE_ARRAY_PARSER = new JavaDoubleBitsFromByteArray();
    private static final JavaDoubleBitsFromCharArray CHAR_ARRAY_PARSER = new JavaDoubleBitsFromCharArray();
    private static final JavaDoubleBitsFromCharSequence CHAR_SEQUENCE_PARSER = new JavaDoubleBitsFromCharSequence();

    private JavaDoubleParser() {
    }

    public static double parseDouble(CharSequence charSequence) throws NumberFormatException {
        return JavaDoubleParser.parseDouble(charSequence, 0, charSequence.length());
    }

    public static double parseDouble(CharSequence charSequence, int n2, int n3) throws NumberFormatException {
        long l2 = CHAR_SEQUENCE_PARSER.parseFloatingPointLiteral(charSequence, n2, n3);
        return Double.longBitsToDouble(l2);
    }

    public static double parseDouble(byte[] byArray) throws NumberFormatException {
        return JavaDoubleParser.parseDouble(byArray, 0, byArray.length);
    }

    public static double parseDouble(byte[] byArray, int n2, int n3) throws NumberFormatException {
        long l2 = BYTE_ARRAY_PARSER.parseFloatingPointLiteral(byArray, n2, n3);
        return Double.longBitsToDouble(l2);
    }

    public static double parseDouble(char[] cArray) throws NumberFormatException {
        return JavaDoubleParser.parseDouble(cArray, 0, cArray.length);
    }

    public static double parseDouble(char[] cArray, int n2, int n3) throws NumberFormatException {
        long l2 = CHAR_ARRAY_PARSER.parseFloatingPointLiteral(cArray, n2, n3);
        return Double.longBitsToDouble(l2);
    }
}

