/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.io.doubleparser;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.NavigableMap;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.io.doubleparser.AbstractBigIntegerParser;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.io.doubleparser.AbstractNumberParser;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.io.doubleparser.FastDoubleSwar;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.io.doubleparser.FastIntegerMath;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.io.doubleparser.ParseDigitsTaskByteArray;

class JavaBigIntegerFromByteArray
extends AbstractBigIntegerParser {
    JavaBigIntegerFromByteArray() {
    }

    public BigInteger parseBigIntegerString(byte[] byArray, int n2, int n3, int n4) throws NumberFormatException {
        try {
            boolean bl2;
            int n5 = AbstractNumberParser.checkBounds(byArray.length, n2, n3);
            int n6 = n2;
            byte by2 = byArray[n6];
            boolean bl3 = bl2 = by2 == 45;
            if ((bl2 || by2 == 43) && (by2 = JavaBigIntegerFromByteArray.charAt(byArray, ++n6, n5)) == 0) {
                throw new NumberFormatException("illegal syntax");
            }
            switch (n4) {
                case 10: {
                    return this.parseDecDigits(byArray, n6, n5, bl2);
                }
                case 16: {
                    return this.parseHexDigits(byArray, n6, n5, bl2);
                }
            }
            return new BigInteger(new String(byArray, n2, n3, StandardCharsets.ISO_8859_1), n4);
        }
        catch (ArithmeticException arithmeticException) {
            NumberFormatException numberFormatException = new NumberFormatException("value exceeds limits");
            numberFormatException.initCause(arithmeticException);
            throw numberFormatException;
        }
    }

    private BigInteger parseDecDigits(byte[] byArray, int n2, int n3, boolean bl2) {
        int n4 = n3 - n2;
        if (JavaBigIntegerFromByteArray.hasManyDigits(n4)) {
            return this.parseManyDecDigits(byArray, n2, n3, bl2);
        }
        int n5 = n2 + (n4 & 7);
        long l2 = FastDoubleSwar.tryToParseUpTo7Digits(byArray, n2, n5);
        boolean bl3 = l2 >= 0L;
        for (n2 = n5; n2 < n3; n2 += 8) {
            int n6 = FastDoubleSwar.tryToParseEightDigitsUtf8(byArray, n2);
            bl3 &= n6 >= 0;
            l2 = l2 * 100000000L + (long)n6;
        }
        if (!bl3) {
            throw new NumberFormatException("illegal syntax");
        }
        return BigInteger.valueOf(bl2 ? -l2 : l2);
    }

    private BigInteger parseHexDigits(byte[] byArray, int n2, int n3, boolean bl2) {
        int n4;
        int n5 = n3 - (n2 = this.skipZeroes(byArray, n2, n3));
        if (n5 <= 0) {
            return BigInteger.ZERO;
        }
        JavaBigIntegerFromByteArray.checkHexBigIntegerBounds(n5);
        byte[] byArray2 = new byte[(n5 + 1 >> 1) + 1];
        int n6 = 1;
        boolean bl3 = false;
        if ((n5 & 1) != 0) {
            n4 = byArray[n2++];
            int by2 = JavaBigIntegerFromByteArray.lookupHex((byte)n4);
            byArray2[n6++] = (byte)by2;
            bl3 = by2 < 0;
        }
        n4 = n2 + (n3 - n2 & 7);
        while (n2 < n4) {
            byte l2 = byArray[n2];
            byte by2 = byArray[n2 + 1];
            int n7 = JavaBigIntegerFromByteArray.lookupHex(l2);
            int n8 = JavaBigIntegerFromByteArray.lookupHex(by2);
            byArray2[n6++] = (byte)(n7 << 4 | n8);
            bl3 |= n7 < 0 || n8 < 0;
            n2 += 2;
        }
        while (n2 < n3) {
            long bigInteger = FastDoubleSwar.tryToParseEightHexDigits(byArray, n2);
            FastDoubleSwar.writeIntBE(byArray2, n6, (int)bigInteger);
            bl3 |= bigInteger < 0L;
            n2 += 8;
            n6 += 4;
        }
        if (bl3) {
            throw new NumberFormatException("illegal syntax");
        }
        BigInteger bigInteger = new BigInteger(byArray2);
        return bl2 ? bigInteger.negate() : bigInteger;
    }

    private BigInteger parseManyDecDigits(byte[] byArray, int n2, int n3, boolean bl2) {
        n2 = this.skipZeroes(byArray, n2, n3);
        int n4 = n3 - n2;
        JavaBigIntegerFromByteArray.checkDecBigIntegerBounds(n4);
        NavigableMap<Integer, BigInteger> navigableMap = FastIntegerMath.fillPowersOf10Floor16(n2, n3);
        BigInteger bigInteger = ParseDigitsTaskByteArray.parseDigitsRecursive(byArray, n2, n3, navigableMap, 400);
        return bl2 ? bigInteger.negate() : bigInteger;
    }

    private int skipZeroes(byte[] byArray, int n2, int n3) {
        while (n2 < n3 - 8 && FastDoubleSwar.isEightZeroes(byArray, n2)) {
            n2 += 8;
        }
        while (n2 < n3 && byArray[n2] == 48) {
            ++n2;
        }
        return n2;
    }
}

