/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core;

import java.io.Serializable;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.ErrorReportConfiguration;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.io.ContentReference;

public class JsonLocation
implements Serializable {
    private static final long serialVersionUID = 2L;
    @Deprecated
    public static final int MAX_CONTENT_SNIPPET = 500;
    public static final JsonLocation NA = new JsonLocation(ContentReference.unknown(), -1L, -1L, -1, -1);
    protected final long _totalBytes;
    protected final long _totalChars;
    protected final int _lineNr;
    protected final int _columnNr;
    protected final ContentReference _contentReference;
    protected transient String _sourceDescription;

    public JsonLocation(ContentReference contentReference, long l2, int n2, int n3) {
        this(contentReference, -1L, l2, n2, n3);
    }

    public JsonLocation(ContentReference contentReference, long l2, long l3, int n2, int n3) {
        if (contentReference == null) {
            contentReference = ContentReference.unknown();
        }
        this._contentReference = contentReference;
        this._totalBytes = l2;
        this._totalChars = l3;
        this._lineNr = n2;
        this._columnNr = n3;
    }

    @Deprecated
    public JsonLocation(Object object, long l2, int n2, int n3) {
        this(JsonLocation._wrap(object), l2, n2, n3);
    }

    @Deprecated
    public JsonLocation(Object object, long l2, long l3, int n2, int n3) {
        this(JsonLocation._wrap(object), l2, l3, n2, n3);
    }

    protected static ContentReference _wrap(Object object) {
        if (object instanceof ContentReference) {
            return (ContentReference)object;
        }
        return ContentReference.construct(false, object, ErrorReportConfiguration.defaults());
    }

    public ContentReference contentReference() {
        return this._contentReference;
    }

    @Deprecated
    public Object getSourceRef() {
        return this._contentReference.getRawContent();
    }

    public int getLineNr() {
        return this._lineNr;
    }

    public int getColumnNr() {
        return this._columnNr;
    }

    public long getCharOffset() {
        return this._totalChars;
    }

    public long getByteOffset() {
        return this._totalBytes;
    }

    public String sourceDescription() {
        if (this._sourceDescription == null) {
            this._sourceDescription = this._contentReference.buildSourceDescription();
        }
        return this._sourceDescription;
    }

    public String offsetDescription() {
        return this.appendOffsetDescription(new StringBuilder(40)).toString();
    }

    public StringBuilder appendOffsetDescription(StringBuilder stringBuilder) {
        if (this._contentReference.hasTextualContent()) {
            stringBuilder.append("line: ");
            if (this._lineNr >= 0) {
                stringBuilder.append(this._lineNr);
            } else {
                stringBuilder.append("UNKNOWN");
            }
            stringBuilder.append(", column: ");
            if (this._columnNr >= 0) {
                stringBuilder.append(this._columnNr);
            } else {
                stringBuilder.append("UNKNOWN");
            }
        } else if (this._lineNr > 0) {
            stringBuilder.append("line: ").append(this._lineNr);
            if (this._columnNr > 0) {
                stringBuilder.append(", column: ");
                stringBuilder.append(this._columnNr);
            }
        } else {
            stringBuilder.append("byte offset: #");
            if (this._totalBytes >= 0L) {
                stringBuilder.append(this._totalBytes);
            } else {
                stringBuilder.append("UNKNOWN");
            }
        }
        return stringBuilder;
    }

    public int hashCode() {
        int n2 = this._contentReference == null ? 1 : 2;
        n2 ^= this._lineNr;
        n2 += this._columnNr;
        n2 ^= (int)this._totalChars;
        return n2 += (int)this._totalBytes;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof JsonLocation)) {
            return false;
        }
        JsonLocation jsonLocation = (JsonLocation)object;
        if (this._contentReference == null ? jsonLocation._contentReference != null : !this._contentReference.equals(jsonLocation._contentReference)) {
            return false;
        }
        return this._lineNr == jsonLocation._lineNr && this._columnNr == jsonLocation._columnNr && this._totalChars == jsonLocation._totalChars && this._totalBytes == jsonLocation._totalBytes;
    }

    public String toString() {
        String string = this.sourceDescription();
        StringBuilder stringBuilder = new StringBuilder(40 + string.length()).append("[Source: ").append(string).append("; ");
        return this.appendOffsetDescription(stringBuilder).append(']').toString();
    }
}

