/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.json.implementation.jackson.core.base;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import macromedia.jdbc.sqlserver.externals.com.azure.json.implementation.jackson.core.Base64Variant;
import macromedia.jdbc.sqlserver.externals.com.azure.json.implementation.jackson.core.JsonGenerator;
import macromedia.jdbc.sqlserver.externals.com.azure.json.implementation.jackson.core.JsonStreamContext;
import macromedia.jdbc.sqlserver.externals.com.azure.json.implementation.jackson.core.ObjectCodec;
import macromedia.jdbc.sqlserver.externals.com.azure.json.implementation.jackson.core.PrettyPrinter;
import macromedia.jdbc.sqlserver.externals.com.azure.json.implementation.jackson.core.SerializableString;
import macromedia.jdbc.sqlserver.externals.com.azure.json.implementation.jackson.core.TreeNode;
import macromedia.jdbc.sqlserver.externals.com.azure.json.implementation.jackson.core.Version;
import macromedia.jdbc.sqlserver.externals.com.azure.json.implementation.jackson.core.json.DupDetector;
import macromedia.jdbc.sqlserver.externals.com.azure.json.implementation.jackson.core.json.JsonWriteContext;
import macromedia.jdbc.sqlserver.externals.com.azure.json.implementation.jackson.core.json.PackageVersion;
import macromedia.jdbc.sqlserver.externals.com.azure.json.implementation.jackson.core.util.DefaultPrettyPrinter;

public abstract class GeneratorBase
extends JsonGenerator {
    public static final int SURR1_FIRST = 55296;
    public static final int SURR1_LAST = 56319;
    public static final int SURR2_FIRST = 56320;
    public static final int SURR2_LAST = 57343;
    protected static final int DERIVED_FEATURES_MASK = JsonGenerator.Feature.WRITE_NUMBERS_AS_STRINGS.getMask() | JsonGenerator.Feature.ESCAPE_NON_ASCII.getMask() | JsonGenerator.Feature.STRICT_DUPLICATE_DETECTION.getMask();
    protected static final String WRITE_BINARY = "write a binary value";
    protected static final String WRITE_BOOLEAN = "write a boolean value";
    protected static final String WRITE_NULL = "write a null";
    protected static final String WRITE_NUMBER = "write a number";
    protected static final String WRITE_RAW = "write a raw (unencoded) value";
    protected static final String WRITE_STRING = "write a string";
    protected static final int MAX_BIG_DECIMAL_SCALE = 9999;
    protected ObjectCodec _objectCodec;
    protected int _features;
    protected boolean _cfgNumbersAsStrings;
    protected JsonWriteContext _writeContext;
    protected boolean _closed;

    protected GeneratorBase(int n2, ObjectCodec objectCodec) {
        this._features = n2;
        this._objectCodec = objectCodec;
        DupDetector dupDetector = JsonGenerator.Feature.STRICT_DUPLICATE_DETECTION.enabledIn(n2) ? DupDetector.rootDetector(this) : null;
        this._writeContext = JsonWriteContext.createRootContext(dupDetector);
        this._cfgNumbersAsStrings = JsonGenerator.Feature.WRITE_NUMBERS_AS_STRINGS.enabledIn(n2);
    }

    protected GeneratorBase(int n2, ObjectCodec objectCodec, JsonWriteContext jsonWriteContext) {
        this._features = n2;
        this._objectCodec = objectCodec;
        this._writeContext = jsonWriteContext;
        this._cfgNumbersAsStrings = JsonGenerator.Feature.WRITE_NUMBERS_AS_STRINGS.enabledIn(n2);
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Override
    public Object getCurrentValue() {
        return this._writeContext.getCurrentValue();
    }

    @Override
    public void setCurrentValue(Object object) {
        if (this._writeContext != null) {
            this._writeContext.setCurrentValue(object);
        }
    }

    @Override
    public final boolean isEnabled(JsonGenerator.Feature feature) {
        return (this._features & feature.getMask()) != 0;
    }

    @Override
    public int getFeatureMask() {
        return this._features;
    }

    @Override
    public JsonGenerator enable(JsonGenerator.Feature feature) {
        int n2 = feature.getMask();
        this._features |= n2;
        if ((n2 & DERIVED_FEATURES_MASK) != 0) {
            if (feature == JsonGenerator.Feature.WRITE_NUMBERS_AS_STRINGS) {
                this._cfgNumbersAsStrings = true;
            } else if (feature == JsonGenerator.Feature.ESCAPE_NON_ASCII) {
                this.setHighestNonEscapedChar(127);
            } else if (feature == JsonGenerator.Feature.STRICT_DUPLICATE_DETECTION && this._writeContext.getDupDetector() == null) {
                this._writeContext = this._writeContext.withDupDetector(DupDetector.rootDetector(this));
            }
        }
        return this;
    }

    @Override
    public JsonGenerator disable(JsonGenerator.Feature feature) {
        int n2 = feature.getMask();
        this._features &= ~n2;
        if ((n2 & DERIVED_FEATURES_MASK) != 0) {
            if (feature == JsonGenerator.Feature.WRITE_NUMBERS_AS_STRINGS) {
                this._cfgNumbersAsStrings = false;
            } else if (feature == JsonGenerator.Feature.ESCAPE_NON_ASCII) {
                this.setHighestNonEscapedChar(0);
            } else if (feature == JsonGenerator.Feature.STRICT_DUPLICATE_DETECTION) {
                this._writeContext = this._writeContext.withDupDetector(null);
            }
        }
        return this;
    }

    @Override
    @Deprecated
    public JsonGenerator setFeatureMask(int n2) {
        int n3 = n2 ^ this._features;
        this._features = n2;
        if (n3 != 0) {
            this._checkStdFeatureChanges(n2, n3);
        }
        return this;
    }

    @Override
    public JsonGenerator overrideStdFeatures(int n2, int n3) {
        int n4 = this._features;
        int n5 = n4 & ~n3 | n2 & n3;
        int n6 = n4 ^ n5;
        if (n6 != 0) {
            this._features = n5;
            this._checkStdFeatureChanges(n5, n6);
        }
        return this;
    }

    protected void _checkStdFeatureChanges(int n2, int n3) {
        if ((n3 & DERIVED_FEATURES_MASK) == 0) {
            return;
        }
        this._cfgNumbersAsStrings = JsonGenerator.Feature.WRITE_NUMBERS_AS_STRINGS.enabledIn(n2);
        if (JsonGenerator.Feature.ESCAPE_NON_ASCII.enabledIn(n3)) {
            if (JsonGenerator.Feature.ESCAPE_NON_ASCII.enabledIn(n2)) {
                this.setHighestNonEscapedChar(127);
            } else {
                this.setHighestNonEscapedChar(0);
            }
        }
        if (JsonGenerator.Feature.STRICT_DUPLICATE_DETECTION.enabledIn(n3)) {
            if (JsonGenerator.Feature.STRICT_DUPLICATE_DETECTION.enabledIn(n2)) {
                if (this._writeContext.getDupDetector() == null) {
                    this._writeContext = this._writeContext.withDupDetector(DupDetector.rootDetector(this));
                }
            } else {
                this._writeContext = this._writeContext.withDupDetector(null);
            }
        }
    }

    @Override
    public JsonGenerator useDefaultPrettyPrinter() {
        if (this.getPrettyPrinter() != null) {
            return this;
        }
        return this.setPrettyPrinter(this._constructDefaultPrettyPrinter());
    }

    @Override
    public JsonGenerator setCodec(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
        return this;
    }

    @Override
    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    @Override
    public JsonStreamContext getOutputContext() {
        return this._writeContext;
    }

    @Override
    public void writeStartObject(Object object) throws IOException {
        this.writeStartObject();
        if (object != null) {
            this.setCurrentValue(object);
        }
    }

    @Override
    public void writeFieldName(SerializableString serializableString) throws IOException {
        this.writeFieldName(serializableString.getValue());
    }

    @Override
    public void writeString(SerializableString serializableString) throws IOException {
        this.writeString(serializableString.getValue());
    }

    @Override
    public void writeRawValue(String string) throws IOException {
        this._verifyValueWrite("write raw value");
        this.writeRaw(string);
    }

    @Override
    public void writeRawValue(String string, int n2, int n3) throws IOException {
        this._verifyValueWrite("write raw value");
        this.writeRaw(string, n2, n3);
    }

    @Override
    public void writeRawValue(char[] cArray, int n2, int n3) throws IOException {
        this._verifyValueWrite("write raw value");
        this.writeRaw(cArray, n2, n3);
    }

    @Override
    public void writeRawValue(SerializableString serializableString) throws IOException {
        this._verifyValueWrite("write raw value");
        this.writeRaw(serializableString);
    }

    @Override
    public int writeBinary(Base64Variant base64Variant, InputStream inputStream, int n2) throws IOException {
        this._reportUnsupportedOperation();
        return 0;
    }

    @Override
    public void writeObject(Object object) throws IOException {
        if (object == null) {
            this.writeNull();
        } else {
            if (this._objectCodec != null) {
                this._objectCodec.writeValue(this, object);
                return;
            }
            this._writeSimpleObject(object);
        }
    }

    @Override
    public void writeTree(TreeNode treeNode) throws IOException {
        if (treeNode == null) {
            this.writeNull();
        } else {
            if (this._objectCodec == null) {
                throw new IllegalStateException("No ObjectCodec defined");
            }
            this._objectCodec.writeValue(this, treeNode);
        }
    }

    @Override
    public abstract void flush() throws IOException;

    @Override
    public void close() throws IOException {
        this._closed = true;
    }

    @Override
    public boolean isClosed() {
        return this._closed;
    }

    protected abstract void _releaseBuffers();

    protected abstract void _verifyValueWrite(String var1) throws IOException;

    protected PrettyPrinter _constructDefaultPrettyPrinter() {
        return new DefaultPrettyPrinter();
    }

    protected String _asString(BigDecimal bigDecimal) throws IOException {
        if (JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN.enabledIn(this._features)) {
            int n2 = bigDecimal.scale();
            if (n2 < -9999 || n2 > 9999) {
                this._reportError(String.format("Attempt to write plain `java.math.BigDecimal` (see JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN) with illegal scale (%d): needs to be between [-%d, %d]", n2, 9999, 9999));
            }
            return bigDecimal.toPlainString();
        }
        return bigDecimal.toString();
    }

    protected final int _decodeSurrogate(int n2, int n3) throws IOException {
        if (n3 < 56320 || n3 > 57343) {
            String string = String.format("Incomplete surrogate pair: first char 0x%04X, second 0x%04X", n2, n3);
            this._reportError(string);
        }
        int n4 = 65536 + (n2 - 55296 << 10) + (n3 - 56320);
        return n4;
    }
}

