/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.json.implementation;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonReader;
import macromedia.jdbc.sqlserver.externals.com.azure.json.implementation.jackson.core.JsonFactory;
import macromedia.jdbc.sqlserver.externals.com.azure.json.implementation.jackson.core.JsonParser;
import macromedia.jdbc.sqlserver.externals.com.azure.json.implementation.jackson.core.JsonToken;
import macromedia.jdbc.sqlserver.externals.com.azure.json.implementation.jackson.core.json.JsonReadFeature;

public final class DefaultJsonReader
extends JsonReader {
    private static final JsonFactory FACTORY = JsonFactory.builder().build();
    private final JsonParser parser;
    private final byte[] jsonBytes;
    private final String jsonString;
    private final boolean resetSupported;
    private final boolean nonNumericNumbersSupported;
    private macromedia.jdbc.sqlserver.externals.com.azure.json.JsonToken currentToken;

    public static JsonReader fromBytes(byte[] byArray, JsonOptions jsonOptions) throws IOException {
        return new DefaultJsonReader(FACTORY.createParser(byArray), true, byArray, null, jsonOptions);
    }

    public static JsonReader fromString(String string, JsonOptions jsonOptions) throws IOException {
        return new DefaultJsonReader(FACTORY.createParser(string), true, null, string, jsonOptions);
    }

    public static JsonReader fromStream(InputStream inputStream, JsonOptions jsonOptions) throws IOException {
        return new DefaultJsonReader(FACTORY.createParser(inputStream), inputStream.markSupported(), null, null, jsonOptions);
    }

    public static JsonReader fromReader(Reader reader, JsonOptions jsonOptions) throws IOException {
        return new DefaultJsonReader(FACTORY.createParser(reader), reader.markSupported(), null, null, jsonOptions);
    }

    private DefaultJsonReader(JsonParser jsonParser, boolean bl2, byte[] byArray, String string, JsonOptions jsonOptions) {
        this(jsonParser, bl2, byArray, string, jsonOptions.isNonNumericNumbersSupported());
    }

    private DefaultJsonReader(JsonParser jsonParser, boolean bl2, byte[] byArray, String string, boolean bl3) {
        this.parser = jsonParser;
        this.parser.configure(JsonReadFeature.ALLOW_NON_NUMERIC_NUMBERS.mappedFeature(), bl3);
        this.resetSupported = bl2;
        this.jsonBytes = byArray;
        this.jsonString = string;
        this.nonNumericNumbersSupported = bl3;
    }

    @Override
    public macromedia.jdbc.sqlserver.externals.com.azure.json.JsonToken currentToken() {
        return this.currentToken;
    }

    @Override
    public macromedia.jdbc.sqlserver.externals.com.azure.json.JsonToken nextToken() throws IOException {
        this.currentToken = DefaultJsonReader.mapToken(this.parser.nextToken(), this.currentToken);
        return this.currentToken;
    }

    @Override
    public byte[] getBinary() throws IOException {
        if (this.currentToken() == macromedia.jdbc.sqlserver.externals.com.azure.json.JsonToken.NULL) {
            return null;
        }
        return this.parser.getBinaryValue();
    }

    @Override
    public boolean getBoolean() throws IOException {
        return this.parser.getBooleanValue();
    }

    @Override
    public double getDouble() throws IOException {
        return this.parser.getDoubleValue();
    }

    @Override
    public float getFloat() throws IOException {
        return this.parser.getFloatValue();
    }

    @Override
    public int getInt() throws IOException {
        return this.parser.getIntValue();
    }

    @Override
    public long getLong() throws IOException {
        return this.parser.getLongValue();
    }

    @Override
    public String getString() throws IOException {
        return this.parser.getValueAsString();
    }

    @Override
    public String getFieldName() throws IOException {
        return this.parser.currentName();
    }

    @Override
    public void skipChildren() throws IOException {
        this.parser.skipChildren();
    }

    @Override
    public JsonReader bufferObject() throws IOException {
        macromedia.jdbc.sqlserver.externals.com.azure.json.JsonToken jsonToken = this.currentToken();
        if (jsonToken == macromedia.jdbc.sqlserver.externals.com.azure.json.JsonToken.START_OBJECT || jsonToken == macromedia.jdbc.sqlserver.externals.com.azure.json.JsonToken.FIELD_NAME) {
            String string = this.readRemainingFieldsAsJsonObject();
            return new DefaultJsonReader(FACTORY.createParser(string), true, null, string, this.nonNumericNumbersSupported);
        }
        throw new IllegalStateException("Cannot buffer a JSON object from a non-object, non-field name starting location. Starting location: " + (Object)((Object)this.currentToken()));
    }

    @Override
    public boolean isResetSupported() {
        return this.resetSupported;
    }

    @Override
    public JsonReader reset() throws IOException {
        if (!this.resetSupported) {
            throw new IllegalStateException("'reset' isn't supported by this JsonReader.");
        }
        if (this.jsonBytes != null) {
            return new DefaultJsonReader(FACTORY.createParser(this.jsonBytes), true, this.jsonBytes, null, this.nonNumericNumbersSupported);
        }
        return new DefaultJsonReader(FACTORY.createParser(this.jsonString), true, null, this.jsonString, this.nonNumericNumbersSupported);
    }

    @Override
    public void close() throws IOException {
        this.parser.close();
    }

    private static macromedia.jdbc.sqlserver.externals.com.azure.json.JsonToken mapToken(JsonToken jsonToken, macromedia.jdbc.sqlserver.externals.com.azure.json.JsonToken jsonToken2) {
        if (jsonToken == null && jsonToken2 == null) {
            return null;
        }
        if (jsonToken == null) {
            return macromedia.jdbc.sqlserver.externals.com.azure.json.JsonToken.END_DOCUMENT;
        }
        switch (jsonToken) {
            case START_OBJECT: {
                return macromedia.jdbc.sqlserver.externals.com.azure.json.JsonToken.START_OBJECT;
            }
            case END_OBJECT: {
                return macromedia.jdbc.sqlserver.externals.com.azure.json.JsonToken.END_OBJECT;
            }
            case START_ARRAY: {
                return macromedia.jdbc.sqlserver.externals.com.azure.json.JsonToken.START_ARRAY;
            }
            case END_ARRAY: {
                return macromedia.jdbc.sqlserver.externals.com.azure.json.JsonToken.END_ARRAY;
            }
            case FIELD_NAME: {
                return macromedia.jdbc.sqlserver.externals.com.azure.json.JsonToken.FIELD_NAME;
            }
            case VALUE_STRING: {
                return macromedia.jdbc.sqlserver.externals.com.azure.json.JsonToken.STRING;
            }
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: {
                return macromedia.jdbc.sqlserver.externals.com.azure.json.JsonToken.NUMBER;
            }
            case VALUE_TRUE: 
            case VALUE_FALSE: {
                return macromedia.jdbc.sqlserver.externals.com.azure.json.JsonToken.BOOLEAN;
            }
            case VALUE_NULL: {
                return macromedia.jdbc.sqlserver.externals.com.azure.json.JsonToken.NULL;
            }
        }
        throw new IllegalStateException("Unsupported token type: '" + (Object)((Object)jsonToken) + "'.");
    }
}

