/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.json.implementation;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonProvider;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonReader;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonWriter;
import macromedia.jdbc.sqlserver.externals.com.azure.json.implementation.DefaultJsonReader;
import macromedia.jdbc.sqlserver.externals.com.azure.json.implementation.DefaultJsonWriter;

public final class DefaultJsonProvider
implements JsonProvider {
    private static final String JSON_READER_EXCEPTION = "Both 'json' and 'options' must be passed as non-null to create an instance of JsonReader.";
    private static final String JSON_WRITER_EXCEPTION = "Both 'json' and 'options' must be passed as non-null to create an instance of JsonWriter.";

    @Override
    public JsonReader createReader(byte[] byArray, JsonOptions jsonOptions) throws IOException {
        DefaultJsonProvider.validate(byArray, jsonOptions, JSON_READER_EXCEPTION);
        return DefaultJsonReader.fromBytes(byArray, jsonOptions);
    }

    @Override
    public JsonReader createReader(String string, JsonOptions jsonOptions) throws IOException {
        DefaultJsonProvider.validate(string, jsonOptions, JSON_READER_EXCEPTION);
        return DefaultJsonReader.fromString(string, jsonOptions);
    }

    @Override
    public JsonReader createReader(InputStream inputStream, JsonOptions jsonOptions) throws IOException {
        DefaultJsonProvider.validate(inputStream, jsonOptions, JSON_READER_EXCEPTION);
        return DefaultJsonReader.fromStream(inputStream, jsonOptions);
    }

    @Override
    public JsonReader createReader(Reader reader, JsonOptions jsonOptions) throws IOException {
        DefaultJsonProvider.validate(reader, jsonOptions, JSON_READER_EXCEPTION);
        return DefaultJsonReader.fromReader(reader, jsonOptions);
    }

    @Override
    public JsonWriter createWriter(OutputStream outputStream, JsonOptions jsonOptions) throws IOException {
        DefaultJsonProvider.validate(outputStream, jsonOptions, JSON_WRITER_EXCEPTION);
        return DefaultJsonWriter.toStream(outputStream, jsonOptions);
    }

    @Override
    public JsonWriter createWriter(Writer writer, JsonOptions jsonOptions) throws IOException {
        DefaultJsonProvider.validate(writer, jsonOptions, JSON_WRITER_EXCEPTION);
        return DefaultJsonWriter.toWriter(writer, jsonOptions);
    }

    private static void validate(Object object, JsonOptions jsonOptions, String string) {
        if (object == null || jsonOptions == null) {
            throw new NullPointerException(string);
        }
    }
}

