/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.json;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ServiceLoader;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonProvider;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonReader;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonWriter;
import macromedia.jdbc.sqlserver.externals.com.azure.json.implementation.DefaultJsonProvider;

public final class JsonProviders {
    private static final JsonOptions DEFAULT_OPTIONS;
    private static final JsonProvider JSON_PROVIDER;

    private JsonProviders() {
    }

    public static JsonReader createReader(byte[] byArray) throws IOException {
        return JsonProviders.createReader(byArray, DEFAULT_OPTIONS);
    }

    public static JsonReader createReader(byte[] byArray, JsonOptions jsonOptions) throws IOException {
        return JSON_PROVIDER.createReader(byArray, jsonOptions);
    }

    public static JsonReader createReader(String string) throws IOException {
        return JsonProviders.createReader(string, DEFAULT_OPTIONS);
    }

    public static JsonReader createReader(String string, JsonOptions jsonOptions) throws IOException {
        return JSON_PROVIDER.createReader(string, jsonOptions);
    }

    public static JsonReader createReader(InputStream inputStream) throws IOException {
        return JsonProviders.createReader(inputStream, DEFAULT_OPTIONS);
    }

    public static JsonReader createReader(InputStream inputStream, JsonOptions jsonOptions) throws IOException {
        return JSON_PROVIDER.createReader(inputStream, jsonOptions);
    }

    public static JsonReader createReader(Reader reader) throws IOException {
        return JsonProviders.createReader(reader, DEFAULT_OPTIONS);
    }

    public static JsonReader createReader(Reader reader, JsonOptions jsonOptions) throws IOException {
        return JSON_PROVIDER.createReader(reader, jsonOptions);
    }

    public static JsonWriter createWriter(OutputStream outputStream) throws IOException {
        return JsonProviders.createWriter(outputStream, DEFAULT_OPTIONS);
    }

    public static JsonWriter createWriter(OutputStream outputStream, JsonOptions jsonOptions) throws IOException {
        return JSON_PROVIDER.createWriter(outputStream, jsonOptions);
    }

    public static JsonWriter createWriter(Writer writer) throws IOException {
        return JsonProviders.createWriter(writer, DEFAULT_OPTIONS);
    }

    public static JsonWriter createWriter(Writer writer, JsonOptions jsonOptions) throws IOException {
        return JSON_PROVIDER.createWriter(writer, jsonOptions);
    }

    static {
        JsonProvider jsonProvider;
        DEFAULT_OPTIONS = new JsonOptions();
        ServiceLoader<JsonProvider> serviceLoader = ServiceLoader.load(JsonProvider.class, JsonProvider.class.getClassLoader());
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<JsonProvider> iterator = serviceLoader.iterator();
        if (iterator.hasNext()) {
            jsonProvider = iterator.next();
            arrayList.add(jsonProvider.getClass().getName());
            JSON_PROVIDER = jsonProvider;
        } else {
            JSON_PROVIDER = new DefaultJsonProvider();
        }
        while (iterator.hasNext()) {
            jsonProvider = iterator.next();
            arrayList.add(jsonProvider.getClass().getName());
        }
        if (arrayList.size() > 1) {
            throw new IllegalStateException("More than one implementation of 'macromedia.jdbc.sqlserver.externals.com.azure.json.JsonProvider' was found on the classpath. At this time 'azure-json' only supports one implementation being on the classpath. Remove all implementations, except the one that should be used during runtime, from 'META-INF/services/macromedia.jdbc.sqlserver.externals.com.azure.json.JsonProvider'. Found implementations were: " + String.join((CharSequence)", ", arrayList));
        }
    }
}

