/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.TokenRequestContext;
import macromedia.jdbc.sqlserver.externals.com.azure.core.exception.ClientAuthenticationException;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.Configuration;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.BrowserCustomizationOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.IdentityClientOptions;

public final class IdentityUtil {
    private static final ClientLogger LOGGER = new ClientLogger(IdentityUtil.class);
    public static final String AZURE_ADDITIONALLY_ALLOWED_TENANTS = "AZURE_ADDITIONALLY_ALLOWED_TENANTS";
    public static final String ALL_TENANTS = "*";
    public static final String DEFAULT_TENANT = "organizations";
    public static final File NULL_FILE = new File(System.getProperty("os.name").startsWith("Windows") ? "NUL" : "/dev/null");

    private IdentityUtil() {
    }

    public static String resolveTenantId(String string, TokenRequestContext tokenRequestContext, IdentityClientOptions identityClientOptions) {
        String string2 = tokenRequestContext.getTenantId();
        if (string2 != null && string != null && !string.equalsIgnoreCase(string2)) {
            String string3;
            if (identityClientOptions.isMultiTenantAuthenticationDisabled()) {
                throw LOGGER.logExceptionAsError(new ClientAuthenticationException("The Multi Tenant Authentication is disabled. An updated Tenant Id provided via TokenRequestContext cannot be used in this scenario. To resolve this issue, set the env var AZURE_IDENTITY_DISABLE_MULTITENANTAUTH to false ", null));
            }
            if ("adfs".equals(string)) {
                throw LOGGER.logExceptionAsError(new ClientAuthenticationException("The credential is configured with`adfs` tenant id and it cannot be replaced with a tenant id challenge provided via TokenRequestContext class. ", null));
            }
            String string4 = string3 = CoreUtils.isNullOrEmpty(string2) ? string : string2;
            if (!(string3.equalsIgnoreCase(string) || identityClientOptions.getAdditionallyAllowedTenants().contains(ALL_TENANTS) || identityClientOptions.getAdditionallyAllowedTenants().contains(string3))) {
                throw LOGGER.logExceptionAsError(new ClientAuthenticationException("The current credential is not configured to acquire tokens for tenant " + string3 + ". To enable acquiring tokens for this tenant add it to the AdditionallyAllowedTenants on the credential options, or add \"*\" to AdditionallyAllowedTenants to allow acquiring tokens for any tenant. See the troubleshooting guide for more information. https://aka.ms/azsdk/java/identity/multitenant/troubleshoot", null));
            }
            return string3;
        }
        return string;
    }

    public static List<String> resolveAdditionalTenants(List<String> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        if (list.contains(ALL_TENANTS)) {
            return Collections.singletonList(ALL_TENANTS);
        }
        return list;
    }

    public static List<String> getAdditionalTenantsFromEnvironment(Configuration configuration) {
        String string = configuration.get(AZURE_ADDITIONALLY_ALLOWED_TENANTS);
        if (!CoreUtils.isNullOrEmpty(string)) {
            return IdentityUtil.resolveAdditionalTenants(Arrays.asList(configuration.get(AZURE_ADDITIONALLY_ALLOWED_TENANTS).split(";")));
        }
        return Collections.emptyList();
    }

    public static boolean browserCustomizationOptionsPresent(BrowserCustomizationOptions browserCustomizationOptions) {
        return !CoreUtils.isNullOrEmpty(browserCustomizationOptions.getErrorMessage()) || !CoreUtils.isNullOrEmpty(browserCustomizationOptions.getSuccessMessage());
    }

    public static byte[] convertInputStreamToByteArray(InputStream inputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[4096];
        try {
            int n2 = inputStream.read(byArray, 0, byArray.length);
            while (n2 != -1) {
                byteArrayOutputStream.write(byArray, 0, n2);
                n2 = inputStream.read(byArray, 0, byArray.length);
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static boolean isWindowsPlatform() {
        return System.getProperty("os.name").contains("Windows");
    }

    public static boolean isLinuxPlatform() {
        return System.getProperty("os.name").contains("Linux");
    }
}

