/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.intellij;

public class Salsa20 {
    private static final int stateSize = 16;
    private static final byte[] sigma = "expand 32-byte k".getBytes();
    private static final byte[] tau = "expand 16-byte k".getBytes();
    private int index = 0;
    private int[] engineState = new int[16];
    private int[] x = new int[16];
    private byte[] keyStream = new byte[64];
    private byte[] workingKey = null;
    private byte[] workingIV = null;
    private boolean initialised = false;
    private int cW0;
    private int cW1;
    private int cW2;

    public void engineInitEncrypt(byte[] byArray, byte[] byArray2) throws Exception {
        this.init(true, byArray, byArray2);
    }

    public void engineInitDecrypt(byte[] byArray, byte[] byArray2) throws Exception {
        this.init(false, byArray, byArray2);
    }

    private void init(boolean bl2, byte[] byArray, byte[] byArray2) {
        if (byArray2 == null || byArray2.length != 8) {
            throw new IllegalArgumentException("Salsa20 requires exactly 8 bytes of IV");
        }
        this.workingKey = byArray;
        this.workingIV = byArray2;
        this.setKey(this.workingKey, this.workingIV);
    }

    public String getAlgorithmName() {
        return "Salsa20";
    }

    public byte returnByte(byte by2) throws Exception {
        if (this.limitExceeded()) {
            throw new IllegalStateException("2^70 byte limit per IV; Change IV");
        }
        if (this.index == 0) {
            this.salsa20WordToByte(this.engineState, this.keyStream);
            this.engineState[8] = this.engineState[8] + 1;
            if (this.engineState[8] == 0) {
                this.engineState[9] = this.engineState[9] + 1;
            }
        }
        byte by3 = (byte)(this.keyStream[this.index] ^ by2);
        this.index = this.index + 1 & 0x3F;
        return by3;
    }

    public final byte[] crypt(byte[] byArray, int n2, int n3) throws Exception {
        byte[] byArray2 = new byte[n3];
        this.crypt(byArray, n2, n3, byArray2, 0);
        return byArray2;
    }

    public void crypt(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws Exception {
        if (!this.initialised) {
            throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
        }
        if (n2 + n3 > byArray.length) {
            throw new IllegalArgumentException("input buffer too short");
        }
        if (n4 + n3 > byArray2.length) {
            throw new IllegalArgumentException("output buffer too short");
        }
        if (this.limitExceeded(n3)) {
            throw new IllegalArgumentException("2^70 byte limit per IV would be exceeded; Change IV");
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            if (this.index == 0) {
                this.salsa20WordToByte(this.engineState, this.keyStream);
                this.engineState[8] = this.engineState[8] + 1;
                if (this.engineState[8] == 0) {
                    this.engineState[9] = this.engineState[9] + 1;
                }
            }
            byArray2[i2 + n4] = (byte)(this.keyStream[this.index] ^ byArray[i2 + n2]);
            this.index = this.index + 1 & 0x3F;
        }
    }

    public void reset() {
        this.setKey(this.workingKey, this.workingIV);
    }

    private void setKey(byte[] byArray, byte[] byArray2) {
        byte[] byArray3;
        this.workingKey = byArray;
        this.workingIV = byArray2;
        this.index = 0;
        this.resetCounter();
        int n2 = 0;
        this.engineState[1] = this.byteToIntLittle(this.workingKey, 0);
        this.engineState[2] = this.byteToIntLittle(this.workingKey, 4);
        this.engineState[3] = this.byteToIntLittle(this.workingKey, 8);
        this.engineState[4] = this.byteToIntLittle(this.workingKey, 12);
        if (this.workingKey.length == 32) {
            byArray3 = sigma;
            n2 = 16;
        } else {
            byArray3 = tau;
        }
        this.engineState[11] = this.byteToIntLittle(this.workingKey, n2);
        this.engineState[12] = this.byteToIntLittle(this.workingKey, n2 + 4);
        this.engineState[13] = this.byteToIntLittle(this.workingKey, n2 + 8);
        this.engineState[14] = this.byteToIntLittle(this.workingKey, n2 + 12);
        this.engineState[0] = this.byteToIntLittle(byArray3, 0);
        this.engineState[5] = this.byteToIntLittle(byArray3, 4);
        this.engineState[10] = this.byteToIntLittle(byArray3, 8);
        this.engineState[15] = this.byteToIntLittle(byArray3, 12);
        this.engineState[6] = this.byteToIntLittle(this.workingIV, 0);
        this.engineState[7] = this.byteToIntLittle(this.workingIV, 4);
        this.engineState[9] = 0;
        this.engineState[8] = 0;
        this.initialised = true;
    }

    private void salsa20WordToByte(int[] nArray, byte[] byArray) {
        int n2;
        int n3;
        System.arraycopy(nArray, 0, this.x, 0, nArray.length);
        for (n3 = 0; n3 < 10; ++n3) {
            this.x[4] = this.x[4] ^ this.rotl(this.x[0] + this.x[12], 7);
            this.x[8] = this.x[8] ^ this.rotl(this.x[4] + this.x[0], 9);
            this.x[12] = this.x[12] ^ this.rotl(this.x[8] + this.x[4], 13);
            this.x[0] = this.x[0] ^ this.rotl(this.x[12] + this.x[8], 18);
            this.x[9] = this.x[9] ^ this.rotl(this.x[5] + this.x[1], 7);
            this.x[13] = this.x[13] ^ this.rotl(this.x[9] + this.x[5], 9);
            this.x[1] = this.x[1] ^ this.rotl(this.x[13] + this.x[9], 13);
            this.x[5] = this.x[5] ^ this.rotl(this.x[1] + this.x[13], 18);
            this.x[14] = this.x[14] ^ this.rotl(this.x[10] + this.x[6], 7);
            this.x[2] = this.x[2] ^ this.rotl(this.x[14] + this.x[10], 9);
            this.x[6] = this.x[6] ^ this.rotl(this.x[2] + this.x[14], 13);
            this.x[10] = this.x[10] ^ this.rotl(this.x[6] + this.x[2], 18);
            this.x[3] = this.x[3] ^ this.rotl(this.x[15] + this.x[11], 7);
            this.x[7] = this.x[7] ^ this.rotl(this.x[3] + this.x[15], 9);
            this.x[11] = this.x[11] ^ this.rotl(this.x[7] + this.x[3], 13);
            this.x[15] = this.x[15] ^ this.rotl(this.x[11] + this.x[7], 18);
            this.x[1] = this.x[1] ^ this.rotl(this.x[0] + this.x[3], 7);
            this.x[2] = this.x[2] ^ this.rotl(this.x[1] + this.x[0], 9);
            this.x[3] = this.x[3] ^ this.rotl(this.x[2] + this.x[1], 13);
            this.x[0] = this.x[0] ^ this.rotl(this.x[3] + this.x[2], 18);
            this.x[6] = this.x[6] ^ this.rotl(this.x[5] + this.x[4], 7);
            this.x[7] = this.x[7] ^ this.rotl(this.x[6] + this.x[5], 9);
            this.x[4] = this.x[4] ^ this.rotl(this.x[7] + this.x[6], 13);
            this.x[5] = this.x[5] ^ this.rotl(this.x[4] + this.x[7], 18);
            this.x[11] = this.x[11] ^ this.rotl(this.x[10] + this.x[9], 7);
            this.x[8] = this.x[8] ^ this.rotl(this.x[11] + this.x[10], 9);
            this.x[9] = this.x[9] ^ this.rotl(this.x[8] + this.x[11], 13);
            this.x[10] = this.x[10] ^ this.rotl(this.x[9] + this.x[8], 18);
            this.x[12] = this.x[12] ^ this.rotl(this.x[15] + this.x[14], 7);
            this.x[13] = this.x[13] ^ this.rotl(this.x[12] + this.x[15], 9);
            this.x[14] = this.x[14] ^ this.rotl(this.x[13] + this.x[12], 13);
            this.x[15] = this.x[15] ^ this.rotl(this.x[14] + this.x[13], 18);
        }
        n3 = 0;
        for (n2 = 0; n2 < 16; ++n2) {
            this.intToByteLittle(this.x[n2] + nArray[n2], byArray, n3);
            n3 += 4;
        }
        for (n2 = 16; n2 < this.x.length; ++n2) {
            this.intToByteLittle(this.x[n2], byArray, n3);
            n3 += 4;
        }
    }

    private byte[] intToByteLittle(int n2, byte[] byArray, int n3) {
        byArray[n3] = (byte)n2;
        byArray[n3 + 1] = (byte)(n2 >>> 8);
        byArray[n3 + 2] = (byte)(n2 >>> 16);
        byArray[n3 + 3] = (byte)(n2 >>> 24);
        return byArray;
    }

    private int rotl(int n2, int n3) {
        return n2 << n3 | n2 >>> -n3;
    }

    private int byteToIntLittle(byte[] byArray, int n2) {
        return byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8 | (byArray[n2 + 2] & 0xFF) << 16 | byArray[n2 + 3] << 24;
    }

    private void resetCounter() {
        this.cW0 = 0;
        this.cW1 = 0;
        this.cW2 = 0;
    }

    private boolean limitExceeded() {
        ++this.cW0;
        if (this.cW0 == 0) {
            ++this.cW1;
            if (this.cW1 == 0) {
                ++this.cW2;
                return (this.cW2 & 0x20) != 0;
            }
        }
        return false;
    }

    private boolean limitExceeded(int n2) {
        if (this.cW0 >= 0) {
            this.cW0 += n2;
        } else {
            this.cW0 += n2;
            if (this.cW0 >= 0) {
                ++this.cW1;
                if (this.cW1 == 0) {
                    ++this.cW2;
                    return (this.cW2 & 0x20) != 0;
                }
            }
        }
        return false;
    }
}

