/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.intellij;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Objects;

public final class LittleEndianDataInputStream
extends FilterInputStream
implements DataInput {
    public LittleEndianDataInputStream(InputStream inputStream) {
        super(Objects.requireNonNull(inputStream));
    }

    @Override
    public String readLine() {
        throw new UnsupportedOperationException("readLine is not supported");
    }

    @Override
    public void readFully(byte[] byArray) throws IOException {
        this.read(this, byArray, 0, byArray.length);
    }

    @Override
    public void readFully(byte[] byArray, int n2, int n3) throws IOException {
        this.read(this, byArray, n2, n3);
    }

    @Override
    public int skipBytes(int n2) throws IOException {
        return (int)this.in.skip(n2);
    }

    @Override
    public int readUnsignedByte() throws IOException {
        int n2 = this.in.read();
        if (0 > n2) {
            throw new EOFException();
        }
        return n2;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        byte by2 = this.readAndCheckByte();
        byte by3 = this.readAndCheckByte();
        return ByteBuffer.wrap(new byte[]{by3, by2}).getShort();
    }

    @Override
    public int readInt() throws IOException {
        byte by2 = this.readAndCheckByte();
        byte by3 = this.readAndCheckByte();
        byte by4 = this.readAndCheckByte();
        byte by5 = this.readAndCheckByte();
        return ByteBuffer.wrap(new byte[]{by5, by4, by3, by2}).getInt();
    }

    @Override
    public long readLong() throws IOException {
        byte by2 = this.readAndCheckByte();
        byte by3 = this.readAndCheckByte();
        byte by4 = this.readAndCheckByte();
        byte by5 = this.readAndCheckByte();
        byte by6 = this.readAndCheckByte();
        byte by7 = this.readAndCheckByte();
        byte by8 = this.readAndCheckByte();
        byte by9 = this.readAndCheckByte();
        return this.bytesToLong(by9, by8, by7, by6, by5, by4, by3, by2);
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public String readUTF() throws IOException {
        return new DataInputStream(this.in).readUTF();
    }

    @Override
    public short readShort() throws IOException {
        return (short)this.readUnsignedShort();
    }

    @Override
    public char readChar() throws IOException {
        return (char)this.readUnsignedShort();
    }

    @Override
    public byte readByte() throws IOException {
        return (byte)this.readUnsignedByte();
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.readUnsignedByte() != 0;
    }

    private byte readAndCheckByte() throws IOException, EOFException {
        int n2 = this.in.read();
        if (-1 == n2) {
            throw new EOFException();
        }
        return (byte)n2;
    }

    public int read(InputStream inputStream, byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        int n5;
        Objects.nonNull(inputStream);
        Objects.nonNull(byArray);
        if (n3 < 0) {
            throw new IndexOutOfBoundsException(String.format("len (%s) cannot be negative", n3));
        }
        for (n4 = 0; n4 < n3 && (n5 = inputStream.read(byArray, n2 + n4, n3 - n4)) != -1; n4 += n5) {
        }
        return n4;
    }

    public long bytesToLong(byte ... byArray) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        byteBuffer.put(byArray, 0, byArray.length);
        byteBuffer.flip();
        return byteBuffer.getLong();
    }
}

