/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.intellij;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Locale;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.CredentialUnavailableException;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.intellij.HashedBlockInputStream;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.intellij.IntelliJCryptoUtil;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.intellij.IntelliJKdbxMetadata;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.intellij.LittleEndianDataInputStream;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.intellij.Salsa20;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class IntelliJKdbxDatabase {
    private static final XPath XPATH = XPathFactory.newInstance().newXPath();
    private static final String STANDARD_PROPERTY_NAME_USER_NAME = "UserName";
    private static final String STANDARD_PROPERTY_NAME_PASSWORD = "Password";
    private static final String STANDARD_PROPERTY_NAME_URL = "URL";
    private static final String STANDARD_PROPERTY_NAME_TITLE = "Title";
    private static final String STANDARD_PROPERTY_NAME_NOTES = "Notes";
    private Element rootElement;

    IntelliJKdbxDatabase(Document document, Element element) {
        this.rootElement = element;
    }

    public static IntelliJKdbxDatabase parse(InputStream inputStream, String string) throws IOException {
        Element element;
        byte[] byArray = IntelliJKdbxDatabase.getDatabaseKey(string);
        IntelliJKdbxMetadata intelliJKdbxMetadata = new IntelliJKdbxMetadata();
        InputStream inputStream2 = IntelliJKdbxDatabase.decryptInputStream(byArray, intelliJKdbxMetadata, inputStream);
        Salsa20 salsa20 = IntelliJCryptoUtil.createSalsa20CryptoEngine(intelliJKdbxMetadata.getEncryptionKey());
        Document document = IntelliJKdbxDatabase.loadDatabase(inputStream2, salsa20);
        try {
            element = (Element)XPATH.evaluate("/KeePassFile/Root/Group", document, XPathConstants.NODE);
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new CredentialUnavailableException("Error loading the database", (Throwable)xPathExpressionException);
        }
        return new IntelliJKdbxDatabase(document, element);
    }

    private static byte[] getDatabaseKey(String string) {
        MessageDigest messageDigest = IntelliJCryptoUtil.getMessageDigestSHA256();
        byte[] byArray = messageDigest.digest(string.getBytes(StandardCharsets.UTF_8));
        return messageDigest.digest(byArray);
    }

    private static InputStream decryptInputStream(byte[] byArray, IntelliJKdbxMetadata intelliJKdbxMetadata, InputStream inputStream) throws IOException {
        IntelliJKdbxDatabase.parseDatabaseMetadata(intelliJKdbxMetadata, inputStream);
        InputStream inputStream2 = IntelliJCryptoUtil.createDecryptedStream(byArray, inputStream, intelliJKdbxMetadata);
        IntelliJKdbxDatabase.validateInitialBytes(intelliJKdbxMetadata, inputStream2);
        HashedBlockInputStream hashedBlockInputStream = new HashedBlockInputStream(inputStream2, true);
        return intelliJKdbxMetadata.getDatabaseCompressionFlags().equals((Object)IntelliJKdbxMetadata.DatabaseCompressionFlags.NONE) ? hashedBlockInputStream : new GZIPInputStream(hashedBlockInputStream);
    }

    private static IntelliJKdbxMetadata parseDatabaseMetadata(IntelliJKdbxMetadata intelliJKdbxMetadata, InputStream inputStream) throws IOException {
        byte by2;
        MessageDigest messageDigest = IntelliJCryptoUtil.getMessageDigestSHA256();
        DigestInputStream digestInputStream = new DigestInputStream(inputStream, messageDigest);
        LittleEndianDataInputStream littleEndianDataInputStream = new LittleEndianDataInputStream(digestInputStream);
        int n2 = littleEndianDataInputStream.readInt();
        int n3 = littleEndianDataInputStream.readInt();
        if (n2 != -1700603645 || n3 != -1253311641) {
            throw new IllegalStateException("Magic number did not match");
        }
        if ((littleEndianDataInputStream.readInt() & 0xFFFF0000) > 196608) {
            throw new IllegalStateException("File version did not match");
        }
        block12: while ((by2 = littleEndianDataInputStream.readByte()) != 0) {
            switch (by2) {
                case 1: {
                    IntelliJKdbxDatabase.readByteArray(littleEndianDataInputStream);
                    continue block12;
                }
                case 2: {
                    intelliJKdbxMetadata.setCipherUuid(IntelliJKdbxDatabase.readByteArray(littleEndianDataInputStream));
                    continue block12;
                }
                case 3: {
                    intelliJKdbxMetadata.setDatabaseCompressionFlags(IntelliJKdbxDatabase.readInt(littleEndianDataInputStream));
                    continue block12;
                }
                case 4: {
                    intelliJKdbxMetadata.setBaseSeed(IntelliJKdbxDatabase.readByteArray(littleEndianDataInputStream));
                    continue block12;
                }
                case 5: {
                    intelliJKdbxMetadata.setTransformSeed(IntelliJKdbxDatabase.readByteArray(littleEndianDataInputStream));
                    continue block12;
                }
                case 6: {
                    intelliJKdbxMetadata.setTransformRounds(IntelliJKdbxDatabase.readLong(littleEndianDataInputStream));
                    continue block12;
                }
                case 7: {
                    intelliJKdbxMetadata.setEncryptionIv(IntelliJKdbxDatabase.readByteArray(littleEndianDataInputStream));
                    continue block12;
                }
                case 8: {
                    intelliJKdbxMetadata.setEncryptionKey(IntelliJKdbxDatabase.readByteArray(littleEndianDataInputStream));
                    continue block12;
                }
                case 9: {
                    intelliJKdbxMetadata.setInitBytes(IntelliJKdbxDatabase.readByteArray(littleEndianDataInputStream));
                    continue block12;
                }
                case 10: {
                    intelliJKdbxMetadata.setEncryptionAlgorithm(IntelliJKdbxDatabase.readInt(littleEndianDataInputStream));
                    continue block12;
                }
            }
            throw new IllegalStateException("Unknown File Header");
        }
        IntelliJKdbxDatabase.readByteArray(littleEndianDataInputStream);
        intelliJKdbxMetadata.setHeaderHash(messageDigest.digest());
        return intelliJKdbxMetadata;
    }

    private static byte[] readByteArray(LittleEndianDataInputStream littleEndianDataInputStream) throws IOException {
        short s2 = littleEndianDataInputStream.readShort();
        byte[] byArray = new byte[s2];
        littleEndianDataInputStream.readFully(byArray);
        return byArray;
    }

    private static void validateInitialBytes(IntelliJKdbxMetadata intelliJKdbxMetadata, InputStream inputStream) throws IOException {
        LittleEndianDataInputStream littleEndianDataInputStream = new LittleEndianDataInputStream(inputStream);
        byte[] byArray = new byte[32];
        littleEndianDataInputStream.readFully(byArray);
        if (!Arrays.equals(byArray, intelliJKdbxMetadata.getInitBytes())) {
            throw new IllegalStateException("Inconsistent stream start bytes. This usually means the credentials were wrong.");
        }
    }

    private static int readInt(LittleEndianDataInputStream littleEndianDataInputStream) throws IOException {
        short s2 = littleEndianDataInputStream.readShort();
        if (s2 != 4) {
            throw new IllegalStateException("Int required but length was " + s2);
        }
        return littleEndianDataInputStream.readInt();
    }

    private static long readLong(LittleEndianDataInputStream littleEndianDataInputStream) throws IOException {
        short s2 = littleEndianDataInputStream.readShort();
        if (s2 != 8) {
            throw new IllegalStateException("Long required but length was " + s2);
        }
        return littleEndianDataInputStream.readLong();
    }

    public static Document loadDatabase(InputStream inputStream, Salsa20 salsa20) throws IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            NodeList nodeList = (NodeList)XPATH.evaluate("//*[@Protected='True']", document, XPathConstants.NODESET);
            for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                Element element = (Element)nodeList.item(i2);
                Element element2 = IntelliJKdbxDatabase.getElement(".", element, false);
                String string = element2 == null ? null : element2.getTextContent();
                byte[] byArray = Base64.getDecoder().decode(string.getBytes(StandardCharsets.UTF_8));
                String string2 = new String(IntelliJCryptoUtil.decrypt(byArray, salsa20), "UTF-8");
                IntelliJKdbxDatabase.setElementContent(".", element, string2);
                element.removeAttribute("Protected");
            }
            return document;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IllegalStateException("Instantiating Document Builder", parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new IllegalStateException("Parsing exception", sAXException);
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new IllegalStateException("XPath Exception", xPathExpressionException);
        }
    }

    private static Element getElement(String string, Element element, boolean bl2) {
        try {
            Element element2 = (Element)XPATH.evaluate(string, element, XPathConstants.NODE);
            if (element2 == null && bl2) {
                element2 = IntelliJKdbxDatabase.buildHierarchialPath(string, element);
            }
            return element2;
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new RuntimeException(xPathExpressionException);
        }
    }

    private static Element buildHierarchialPath(String string, Element element) {
        Element element2 = element;
        String[] stringArray = string.split("/");
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string2 = stringArray[i2];
            try {
                Element element3 = (Element)XPATH.evaluate(string2, element2, XPathConstants.NODE);
                if (element3 == null) {
                    element3 = (Element)element2.appendChild(element2.getOwnerDocument().createElement(string2));
                }
                element2 = element3;
                continue;
            }
            catch (XPathExpressionException xPathExpressionException) {
                throw new RuntimeException(xPathExpressionException);
            }
        }
        return element2;
    }

    static Element setElementContent(String string, Element element, String string2) {
        Element element2 = IntelliJKdbxDatabase.getElement(string, element, true);
        element2.setTextContent(string2);
        return element2;
    }

    public static boolean match(Element element, String string) {
        String string2 = IntelliJKdbxDatabase.getProperty(element, STANDARD_PROPERTY_NAME_TITLE);
        String string3 = IntelliJKdbxDatabase.getProperty(element, STANDARD_PROPERTY_NAME_NOTES);
        String string4 = IntelliJKdbxDatabase.getProperty(element, STANDARD_PROPERTY_NAME_URL);
        String string5 = IntelliJKdbxDatabase.getProperty(element, STANDARD_PROPERTY_NAME_USER_NAME);
        return IntelliJKdbxDatabase.matchString(string2, string) || IntelliJKdbxDatabase.matchString(string3, string) || IntelliJKdbxDatabase.matchString(string4, string) || IntelliJKdbxDatabase.matchString(string5, string);
    }

    public static boolean matchString(String string, String string2) {
        return string != null && string.toLowerCase(Locale.getDefault()).contains(string2.toLowerCase(Locale.getDefault()));
    }

    private String getDatabaseEntryValue(Element element, String string) {
        for (Element element2 : IntelliJKdbxDatabase.getElements("Entry", element)) {
            if (!IntelliJKdbxDatabase.match(element2, string)) continue;
            return IntelliJKdbxDatabase.getProperty(element2, STANDARD_PROPERTY_NAME_PASSWORD);
        }
        for (Element element2 : IntelliJKdbxDatabase.getGroups(element)) {
            this.getDatabaseEntryValue(element2, string);
        }
        return null;
    }

    public String getDatabaseEntryValue(String string) {
        return this.getDatabaseEntryValue(this.rootElement, string);
    }

    static String getElementContent(String string, Element element) {
        Element element2 = IntelliJKdbxDatabase.getElement(string, element, false);
        return element2 == null ? null : element2.getTextContent();
    }

    public static String getProperty(Element element, String string) {
        Element element2 = IntelliJKdbxDatabase.getElement(String.format("String[Key/text()='%s']", string), element, false);
        return element2 == null ? null : IntelliJKdbxDatabase.getElementContent("Value", element2);
    }

    static List<Element> getElements(String string, Element element) {
        try {
            NodeList nodeList = (NodeList)XPATH.evaluate(string, element, XPathConstants.NODESET);
            ArrayList<Element> arrayList = new ArrayList<Element>(nodeList.getLength());
            for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                arrayList.add((Element)nodeList.item(i2));
            }
            return arrayList;
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new IllegalStateException(xPathExpressionException);
        }
    }

    public static List<Element> getGroups(Element element) {
        List<Element> list = IntelliJKdbxDatabase.getElements("Group", element);
        return list;
    }
}

