/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.intellij;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.CredentialUnavailableException;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.intellij.Aes;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.intellij.IntelliJKdbxMetadata;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.intellij.Salsa20;

public class IntelliJCryptoUtil {
    private static final byte[] SALSA20_IV = IntelliJCryptoUtil.decodeHexString("E830094B97205D2A");

    public static MessageDigest getMessageDigestSHA256() {
        try {
            return MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CredentialUnavailableException("Algorithm SHA-256 is not supported. Decryption of IntelliJ Token data is not possible.", (Throwable)noSuchAlgorithmException);
        }
    }

    public static byte[] createKey(byte[] byArray, byte[] byArray2, byte[] byArray3, long l2) {
        byte[] byArray4 = Aes.transformKey(byArray3, byArray, l2);
        MessageDigest messageDigest = IntelliJCryptoUtil.getMessageDigestSHA256();
        byte[] byArray5 = messageDigest.digest(byArray4);
        messageDigest.update(byArray2);
        return messageDigest.digest(byArray5);
    }

    public static InputStream getDecryptedInputStream(InputStream inputStream, byte[] byArray, byte[] byArray2) {
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "AES");
            IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray2);
            cipher.init(2, (Key)secretKeySpec, ivParameterSpec);
            return new CipherInputStream(inputStream, cipher);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException generalSecurityException) {
            throw new CredentialUnavailableException("Error Decrypting the IntelliJ cache database.", (Throwable)generalSecurityException);
        }
    }

    public static Salsa20 createSalsa20CryptoEngine(byte[] byArray) {
        Salsa20 salsa20;
        try {
            MessageDigest messageDigest = IntelliJCryptoUtil.getMessageDigestSHA256();
            byte[] byArray2 = messageDigest.digest(byArray);
            salsa20 = new Salsa20();
            salsa20.engineInitDecrypt(byArray2, SALSA20_IV);
        }
        catch (Exception exception) {
            throw new CredentialUnavailableException("Error creating the Salsa 20 Decryption Engine.", (Throwable)exception);
        }
        return salsa20;
    }

    public static byte[] decrypt(byte[] byArray, Salsa20 salsa20) {
        try {
            return salsa20.crypt(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            throw new CredentialUnavailableException("Error decrypting the IntelliJ database.", (Throwable)exception);
        }
    }

    public static InputStream createDecryptedStream(byte[] byArray, InputStream inputStream, IntelliJKdbxMetadata intelliJKdbxMetadata) {
        byte[] byArray2 = IntelliJCryptoUtil.createKey(byArray, intelliJKdbxMetadata.getBaseSeed(), intelliJKdbxMetadata.getTransformSeed(), intelliJKdbxMetadata.getTransformRounds());
        return IntelliJCryptoUtil.getDecryptedInputStream(inputStream, byArray2, intelliJKdbxMetadata.getEncryptionIv());
    }

    public static byte[] decodeHexString(String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i2 = 0; i2 < string.length(); i2 += 2) {
            int n2 = Integer.parseInt(string.substring(i2, i2 + 2), 16);
            byteArrayOutputStream.write(n2);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

