/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.intellij;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public class HashedBlockInputStream
extends InputStream {
    private static MessageDigest md5;
    private static final int HASH_SIZE = 32;
    private static final byte[] ZERO_HASH;
    private long expectedSequenceNumber = 0L;
    private boolean littleEndian = false;
    private boolean done = false;
    private InputStream inputStream;
    private ByteArrayInputStream blockInputStream = new ByteArrayInputStream(new byte[0]);

    public HashedBlockInputStream(InputStream inputStream) {
        this(inputStream, false);
    }

    public HashedBlockInputStream(InputStream inputStream, boolean bl2) {
        this.inputStream = inputStream;
        this.littleEndian = bl2;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        return this.get(byArray, n2, n3);
    }

    @Override
    public int read() throws IOException {
        byte[] byArray = new byte[1];
        if (this.get(byArray, 0, 1) != 1) {
            throw new IOException("Could not read int");
        }
        return byArray[0] & 0xFF;
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    protected int get(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        if (this.done) {
            return -1;
        }
        int n5 = 0;
        while ((n4 = this.blockInputStream.read(byArray, n2, n3)) < n3 && !this.done) {
            if (n4 == -1) {
                this.load();
                continue;
            }
            n2 += n4;
            n3 -= n4;
            n5 += n4;
        }
        return n4 > 0 ? n5 + n4 : n5;
    }

    protected void load() throws IOException {
        long l2 = this.readUInt();
        if (l2 != this.expectedSequenceNumber) {
            throw new IllegalStateException("Expected sequence number " + this.expectedSequenceNumber + " got " + l2);
        }
        ++this.expectedSequenceNumber;
        byte[] byArray = new byte[32];
        this.readFully(byArray);
        long l3 = this.readUInt();
        if (l3 < 0L) {
            throw new IllegalStateException("Got negative length for block");
        }
        if (l3 == 0L) {
            if (!Arrays.equals(byArray, ZERO_HASH)) {
                throw new IllegalStateException("Block hash was not zero on final block");
            }
            this.done = true;
            return;
        }
        byte[] byArray2 = new byte[(int)l3];
        this.readFully(byArray2);
        md5.update(byArray2);
        if (!Arrays.equals(md5.digest(), byArray)) {
            throw new IllegalStateException("MD5 check failed while reading HashBlock");
        }
        this.blockInputStream = new ByteArrayInputStream(byArray2);
    }

    private long readUInt() throws IOException {
        byte[] byArray = new byte[4];
        this.readFully(byArray);
        if (this.littleEndian) {
            return byArray[3] << 24 | (byArray[2] & 0xFF) << 16 | (byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF;
        }
        return byArray[0] << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
    }

    private void readFully(byte[] byArray) throws IOException {
        int n2 = byArray.length;
        int n3 = 0;
        while (n3 < byArray.length) {
            int n4 = this.inputStream.read(byArray, n3, n2);
            if (n4 <= 0) {
                throw new EOFException();
            }
            n3 += n4;
            n2 -= n4;
        }
    }

    static {
        try {
            md5 = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException(noSuchAlgorithmException);
        }
        ZERO_HASH = new byte[32];
    }
}

