/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Locale;
import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.AccessToken;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.annotation.JsonCreator;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.annotation.JsonProperty;

public final class MSIToken
extends AccessToken {
    private static final ClientLogger LOGGER = new ClientLogger(MSIToken.class);
    private static final OffsetDateTime EPOCH = OffsetDateTime.of(1970, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC);
    private static final DateTimeFormatter DTF = DateTimeFormatter.ofPattern("M/d/yyyy H:mm:ss XXX").withLocale(Locale.US);
    private static final DateTimeFormatter DTF_WINDOWS = DateTimeFormatter.ofPattern("M/d/yyyy h:mm:ss a XXX").withLocale(Locale.US);
    @JsonProperty(value="token_type")
    private String tokenType;
    @JsonProperty(value="access_token")
    private String accessToken;
    @JsonProperty(value="expires_on")
    private String expiresOn;
    @JsonProperty(value="expires_in")
    private String expiresIn;

    @JsonCreator
    public MSIToken(@JsonProperty(value="access_token") String string, @JsonProperty(value="expires_on") String string2, @JsonProperty(value="expires_in") String string3) {
        super(string, EPOCH.plusSeconds(MSIToken.parseToEpochSeconds(string2, string3)));
        this.accessToken = string;
        this.expiresOn = string2;
        this.expiresIn = string3;
    }

    @Override
    public String getToken() {
        return this.accessToken;
    }

    private static Long parseToEpochSeconds(String string, String string2) {
        String string3 = CoreUtils.isNullOrEmpty(string) ? string2 : string;
        try {
            long l2 = Long.parseLong(string3);
            if (!CoreUtils.isNullOrEmpty(string)) {
                return l2;
            }
            return OffsetDateTime.now(ZoneOffset.UTC).plusSeconds(l2).toEpochSecond();
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.verbose(numberFormatException.getMessage());
            try {
                return Instant.from(DTF.parse(string3)).getEpochSecond();
            }
            catch (DateTimeParseException dateTimeParseException) {
                LOGGER.verbose(dateTimeParseException.getMessage());
                try {
                    return Instant.from(DTF_WINDOWS.parse(string3)).getEpochSecond();
                }
                catch (DateTimeParseException dateTimeParseException2) {
                    LOGGER.verbose(dateTimeParseException2.getMessage());
                    throw LOGGER.logExceptionAsError(new IllegalArgumentException("Unable to parse date time " + string3));
                }
            }
        }
    }
}

