/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation;

import com.microsoft.aad.msal4jextensions.persistence.linux.ISecurityLibrary;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;

public class LinuxKeyRingAccessor {
    private static final ClientLogger LOGGER = new ClientLogger(LinuxKeyRingAccessor.class);
    private String keyringSchemaName;
    private String attributeKey1;
    private String attributeValue1;
    private String attributeKey2;
    private String attributeValue2;
    private Pointer libSecretSchema;

    public LinuxKeyRingAccessor(String string, String string2, String string3, String string4, String string5) {
        this.keyringSchemaName = string;
        this.attributeKey1 = string2;
        this.attributeValue1 = string3;
        this.attributeKey2 = string4;
        this.attributeValue2 = string5;
    }

    private byte[] read(String string, String string2) {
        byte[] byArray = null;
        Pointer[] pointerArray = new Pointer[1];
        String string3 = ISecurityLibrary.library.secret_password_lookup_sync(this.getLibSecretSchema(), (Pointer)null, pointerArray, this.attributeKey1, string, this.attributeKey2, string2, (Pointer)null);
        if (pointerArray[0] != Pointer.NULL) {
            GError gError = new GError(pointerArray[0]);
            throw LOGGER.logExceptionAsError(new RuntimeException("An error while reading secret from keyring, domain:" + gError.domain + " code:" + gError.code + " message:" + gError.message));
        }
        if (string3 != null && !string3.isEmpty()) {
            byArray = string3.getBytes(StandardCharsets.UTF_8);
        }
        return byArray;
    }

    public byte[] read() {
        return this.read(this.attributeValue1, this.attributeValue2);
    }

    private Pointer getLibSecretSchema() {
        if (this.libSecretSchema == Pointer.NULL) {
            this.libSecretSchema = ISecurityLibrary.library.secret_schema_new(this.keyringSchemaName, 0, this.attributeKey1, 0, this.attributeKey2, 0, (Pointer)null);
            if (this.libSecretSchema == Pointer.NULL) {
                throw LOGGER.logExceptionAsError(new RuntimeException("Failed to create libSecret schema " + this.keyringSchemaName));
            }
        }
        return this.libSecretSchema;
    }

    static class GError
    extends Structure {
        int domain;
        int code;
        String message;

        GError(Pointer pointer) {
            super(pointer);
            this.read();
        }

        protected List<String> getFieldOrder() {
            return Arrays.asList("domain", "code", "message");
        }
    }
}

