/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation;

import com.microsoft.aad.msal4jextensions.persistence.CacheFileAccessor;
import com.microsoft.aad.msal4jextensions.persistence.mac.KeyChainAccessor;
import com.sun.jna.Platform;
import com.sun.jna.platform.win32.Crypt32Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.CredentialUnavailableException;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.IntelliJAuthMethodDetails;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.LinuxKeyRingAccessor;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.PersistentTokenCacheImpl;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.intellij.IntelliJKdbxDatabase;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.TreeNode;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.DeserializationFeature;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonNode;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.ObjectMapper;

public class IntelliJCacheAccessor {
    private static final ClientLogger LOGGER = new ClientLogger(IntelliJCacheAccessor.class);
    public static final String INTELLIJ_TOOLKIT_CACHE = "azure-toolkit.cache";
    private final String keePassDatabasePath;
    private static final byte[] CRYPTO_KEY = new byte[]{80, 114, 111, 120, 121, 32, 67, 111, 110, 102, 105, 103, 32, 83, 101, 99};
    private static final ObjectMapper DEFAULT_MAPPER = new ObjectMapper();
    private static final ObjectMapper DONT_FAIL_ON_UNKNOWN_PROPERTIES_MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    public IntelliJCacheAccessor(String string) {
        this.keePassDatabasePath = string;
    }

    private List<String> getAzureToolsForIntelliJPluginConfigPaths() {
        return Arrays.asList(Paths.get(System.getProperty("user.home"), "AzureToolsForIntelliJ").toString(), Paths.get(System.getProperty("user.home"), ".AzureToolsForIntelliJ").toString());
    }

    public String getIntelliJCredentialsFromIdentityMsalCache() {
        if (Platform.isMac()) {
            try {
                KeyChainAccessor keyChainAccessor = new KeyChainAccessor(null, "Microsoft.Developer.IdentityService", INTELLIJ_TOOLKIT_CACHE);
                String string = new String(keyChainAccessor.read(), StandardCharsets.UTF_8);
                return this.parseRefreshTokenFromJson(string);
            }
            catch (Error | Exception throwable) {
                LOGGER.verbose("IntelliJCredential => Refresh Token Cache Unavailable: " + throwable.getMessage());
            }
        } else if (Platform.isLinux()) {
            try {
                LinuxKeyRingAccessor linuxKeyRingAccessor = new LinuxKeyRingAccessor("com.intellij.credentialStore.Credential", "service", "Microsoft.Developer.IdentityService", "account", INTELLIJ_TOOLKIT_CACHE);
                String string = new String(linuxKeyRingAccessor.read(), StandardCharsets.UTF_8);
                return this.parseRefreshTokenFromJson(string);
            }
            catch (Error | Exception throwable) {
                LOGGER.verbose("IntelliJCredential => Refresh Token Cache Unavailable: " + throwable.getMessage());
            }
        } else if (Platform.isWindows()) {
            try {
                CacheFileAccessor cacheFileAccessor = new CacheFileAccessor(PersistentTokenCacheImpl.DEFAULT_CACHE_FILE_PATH + File.separator + INTELLIJ_TOOLKIT_CACHE);
                String string = new String(cacheFileAccessor.read(), StandardCharsets.UTF_8);
                return this.parseRefreshTokenFromJson(string);
            }
            catch (Error | Exception throwable) {
                LOGGER.verbose("IntelliJCredential => Refresh Token Cache Unavailable: " + throwable.getMessage());
            }
        } else {
            LOGGER.verbose(String.format("OS %s Platform not supported.", Platform.getOSType()));
        }
        return null;
    }

    private String parseRefreshTokenFromJson(String string) {
        try {
            JsonNode jsonNode = DEFAULT_MAPPER.readTree(string);
            JsonNode jsonNode2 = jsonNode.get("RefreshToken");
            TreeNode treeNode = jsonNode2.get(jsonNode2.fieldNames().next());
            TreeNode treeNode2 = treeNode.get("secret");
            String string2 = treeNode2.toString();
            if (string2.startsWith("\"")) {
                return string2.substring(1, string2.length() - 1);
            }
            return string2;
        }
        catch (Exception exception) {
            LOGGER.verbose("IntelliJCredential => Refresh Token not found: " + exception.getMessage());
            return null;
        }
    }

    public JsonNode getDeviceCodeCredentials() throws IOException {
        if (Platform.isMac()) {
            KeyChainAccessor keyChainAccessor = new KeyChainAccessor(null, "ADAuthManager", "cachedAuthResult");
            String string = new String(keyChainAccessor.read(), StandardCharsets.UTF_8);
            return DEFAULT_MAPPER.readTree(string);
        }
        if (Platform.isLinux()) {
            LinuxKeyRingAccessor linuxKeyRingAccessor = new LinuxKeyRingAccessor("com.intellij.credentialStore.Credential", "service", "ADAuthManager", "account", "cachedAuthResult");
            String string = new String(linuxKeyRingAccessor.read(), StandardCharsets.UTF_8);
            if (string.startsWith("cachedAuthResult@")) {
                string = string.substring("cachedAuthResult@".length());
            }
            return DEFAULT_MAPPER.readTree(string);
        }
        if (Platform.isWindows()) {
            return this.getCredentialFromKdbx();
        }
        throw LOGGER.logExceptionAsError(new RuntimeException(String.format("OS %s Platform not supported.", Platform.getOSType())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getIntellijServicePrincipalDetails(String string) throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>(8);
        try (BufferedReader bufferedReader = null;){
            bufferedReader = new BufferedReader(new FileReader(string));
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                String[] stringArray = string2.split("=");
                stringArray[1] = stringArray[1].replace("\\", "");
                hashMap.put(stringArray[0], stringArray[1]);
                string2 = bufferedReader.readLine();
            }
        }
        return hashMap;
    }

    private JsonNode getCredentialFromKdbx() throws IOException {
        JsonNode jsonNode;
        String string;
        Object object;
        if (CoreUtils.isNullOrEmpty(this.keePassDatabasePath)) {
            throw new CredentialUnavailableException("The KeePass database path is either empty or not configured. Please configure it on the builder. It is required to use IntelliJ credential on the windows platform.");
        }
        String string2 = this.getKdbxPassword();
        SecretKeySpec secretKeySpec = new SecretKeySpec(CRYPTO_KEY, "AES");
        byte[] byArray = Crypt32Util.cryptUnprotectData((byte[])Base64.getDecoder().decode(string2));
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            int n2 = byteBuffer.getInt();
            cipher.init(2, (Key)secretKeySpec, new IvParameterSpec(byArray, byteBuffer.position(), n2));
            int n3 = byteBuffer.position() + n2;
            object = cipher.doFinal(byArray, n3, byArray.length - n3);
            string = new String((byte[])object, StandardCharsets.UTF_8);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException generalSecurityException) {
            throw LOGGER.logExceptionAsError(new RuntimeException("Unable to access cache.", generalSecurityException));
        }
        FileInputStream fileInputStream = new FileInputStream(this.keePassDatabasePath);
        try {
            IntelliJKdbxDatabase intelliJKdbxDatabase = IntelliJKdbxDatabase.parse(fileInputStream, string);
            object = intelliJKdbxDatabase.getDatabaseEntryValue("ADAuthManager");
            if (CoreUtils.isNullOrEmpty((CharSequence)object)) {
                throw new CredentialUnavailableException("No credentials found in the cache. Please login with IntelliJ Azure Tools plugin in the IDE.");
            }
            jsonNode = DEFAULT_MAPPER.readTree((String)object);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exception) {
                throw LOGGER.logExceptionAsError(new RuntimeException("Failed to read KeePass database.", exception));
            }
        }
        ((InputStream)fileInputStream).close();
        return jsonNode;
    }

    private String getKdbxPassword() throws IOException {
        String string = new File(this.keePassDatabasePath).getParent() + File.separator + "c.pwd";
        String string2 = "";
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(string));){
            String string3 = bufferedReader.readLine();
            while (string3 != null) {
                if (string3.contains("value")) {
                    String[] stringArray = string3.split(" ");
                    if (stringArray.length == 3) {
                        string2 = stringArray[2];
                        break;
                    }
                    throw LOGGER.logExceptionAsError(new RuntimeException("Password not found in the file."));
                }
                string3 = bufferedReader.readLine();
            }
        }
        return string2;
    }

    public String getAzureAuthHost(String string) {
        switch (string) {
            case "GLOBAL": {
                return "https://login.microsoftonline.com/";
            }
            case "CHINA": {
                return "https://login.chinacloudapi.cn/";
            }
            case "GERMAN": {
                return "https://login.microsoftonline.de/";
            }
            case "US_GOVERNMENT": {
                return "https://login.microsoftonline.us/";
            }
        }
        return "https://login.microsoftonline.com/";
    }

    public IntelliJAuthMethodDetails parseAuthMethodDetails(File file) throws IOException {
        return DONT_FAIL_ON_UNKNOWN_PROPERTIES_MAPPER.readValue(file, IntelliJAuthMethodDetails.class);
    }

    public IntelliJAuthMethodDetails getAuthDetailsIfAvailable() throws IOException {
        String string;
        String string2;
        File file = null;
        Object object = this.getAzureToolsForIntelliJPluginConfigPaths().iterator();
        while (object.hasNext() && !(file = new File(string2 = Paths.get(string = object.next(), "AuthMethodDetails.json").toString())).exists()) {
        }
        if (file == null || !file.exists()) {
            return null;
        }
        try {
            object = this.parseAuthMethodDetails(file);
        }
        catch (IOException iOException) {
            throw new CredentialUnavailableException("Error Parsing Authentication Method details.", (Throwable)iOException);
        }
        string = ((IntelliJAuthMethodDetails)object).getAuthMethod();
        if (CoreUtils.isNullOrEmpty(string)) {
            return null;
        }
        if ("SP".equalsIgnoreCase(string) ? CoreUtils.isNullOrEmpty(((IntelliJAuthMethodDetails)object).getCredFilePath()) : "DC".equalsIgnoreCase(string) && CoreUtils.isNullOrEmpty(((IntelliJAuthMethodDetails)object).getAccountEmail())) {
            return null;
        }
        return object;
    }
}

