/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation;

import java.time.Duration;
import java.util.function.Supplier;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.IdentityClient;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.IdentityClientOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.IdentitySyncClient;

public final class IdentityClientBuilder {
    private IdentityClientOptions identityClientOptions = new IdentityClientOptions();
    private String tenantId;
    private String clientId;
    private String resourceId;
    private String clientSecret;
    private String clientAssertionPath;
    private String certificatePath;
    private byte[] certificate;
    private String certificatePassword;
    private boolean sharedTokenCacheCred;
    private Duration clientAssertionTimeout;
    private Supplier<String> clientAssertionSupplier;

    public IdentityClientBuilder tenantId(String string) {
        this.tenantId = string;
        return this;
    }

    public IdentityClientBuilder clientId(String string) {
        this.clientId = string;
        return this;
    }

    public IdentityClientBuilder resourceId(String string) {
        this.resourceId = string;
        return this;
    }

    public IdentityClientBuilder clientSecret(String string) {
        this.clientSecret = string;
        return this;
    }

    public IdentityClientBuilder certificatePath(String string) {
        this.certificatePath = string;
        return this;
    }

    public IdentityClientBuilder clientAssertionSupplier(Supplier<String> supplier) {
        this.clientAssertionSupplier = supplier;
        return this;
    }

    public IdentityClientBuilder clientAssertionPath(String string) {
        this.clientAssertionPath = string;
        return this;
    }

    public IdentityClientBuilder certificate(byte[] byArray) {
        this.certificate = byArray;
        return this;
    }

    public IdentityClientBuilder certificatePassword(String string) {
        this.certificatePassword = string;
        return this;
    }

    public IdentityClientBuilder identityClientOptions(IdentityClientOptions identityClientOptions) {
        this.identityClientOptions = identityClientOptions;
        return this;
    }

    public IdentityClientBuilder sharedTokenCacheCredential(boolean bl2) {
        this.sharedTokenCacheCred = bl2;
        return this;
    }

    public IdentityClientBuilder clientAssertionTimeout(Duration duration) {
        this.clientAssertionTimeout = duration;
        return this;
    }

    public IdentityClient build() {
        return new IdentityClient(this.tenantId, this.clientId, this.clientSecret, this.certificatePath, this.clientAssertionPath, this.resourceId, this.clientAssertionSupplier, this.certificate, this.certificatePassword, this.sharedTokenCacheCred, this.clientAssertionTimeout, this.identityClientOptions);
    }

    public IdentitySyncClient buildSyncClient() {
        return new IdentitySyncClient(this.tenantId, this.clientId, this.clientSecret, this.certificatePath, this.clientAssertionPath, this.resourceId, this.clientAssertionSupplier, this.certificate, this.certificatePassword, this.sharedTokenCacheCred, this.clientAssertionTimeout, this.identityClientOptions);
    }
}

