/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.type.TypeReference;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonNode;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.ObjectMapper;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.ObjectReader;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ClaimsRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalClientException;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.RequestedClaimAdditionalInfo;

public class CustomClaimRequest
extends ClaimsRequest {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    @Override
    protected void requestClaimInAccessToken(String string, RequestedClaimAdditionalInfo requestedClaimAdditionalInfo) {
        super.requestClaimInAccessToken(string, requestedClaimAdditionalInfo);
    }

    public static ClaimsRequest formatAsClaimsRequest(String string) {
        try {
            CustomClaimRequest customClaimRequest = new CustomClaimRequest();
            ObjectReader objectReader = MAPPER.readerFor(new TypeReference<List<String>>(){});
            JsonNode jsonNode = MAPPER.readTree(string);
            CustomClaimRequest.addClaimsFromJsonNode(jsonNode.get("id_token"), "id_token", customClaimRequest, objectReader);
            CustomClaimRequest.addClaimsFromJsonNode(jsonNode.get("userinfo"), "userinfo", customClaimRequest, objectReader);
            CustomClaimRequest.addClaimsFromJsonNode(jsonNode.get("access_token"), "access_token", customClaimRequest, objectReader);
            return customClaimRequest;
        }
        catch (IOException iOException) {
            throw new MsalClientException("Could not convert string to ClaimsRequest: " + iOException.getMessage(), "invalid_json");
        }
    }

    private static void addClaimsFromJsonNode(JsonNode jsonNode, String string, CustomClaimRequest customClaimRequest, ObjectReader objectReader) throws IOException {
        if (jsonNode != null) {
            Iterator<String> iterator = jsonNode.fieldNames();
            while (iterator.hasNext()) {
                String string2 = iterator.next();
                Boolean bl2 = null;
                String string3 = null;
                List list = null;
                RequestedClaimAdditionalInfo requestedClaimAdditionalInfo = null;
                if (jsonNode.get(string2).has("essential")) {
                    bl2 = jsonNode.get(string2).get("essential").asBoolean();
                }
                if (jsonNode.get(string2).has("value")) {
                    string3 = jsonNode.get(string2).get("value").textValue();
                }
                if (jsonNode.get(string2).has("values")) {
                    list = (List)objectReader.readValue(jsonNode.get(string2).get("values"));
                }
                if (bl2 != null || string3 != null || list != null) {
                    requestedClaimAdditionalInfo = new RequestedClaimAdditionalInfo(bl2 == null ? false : bl2, string3, list);
                }
                if ("id_token".equals(string)) {
                    customClaimRequest.requestClaimInIdToken(string2, requestedClaimAdditionalInfo);
                }
                if (!"access_token".equals(string)) continue;
                customClaimRequest.requestClaimInAccessToken(string2, requestedClaimAdditionalInfo);
            }
        }
    }
}

