/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.identity;

import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.AccessToken;
import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.TokenCredential;
import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.TokenRequestContext;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.Configuration;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.CredentialUnavailableException;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.IdentityClient;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.IdentityClientBuilder;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.IdentityClientOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.IdentitySyncClient;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.util.LoggingUtil;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.util.ValidationUtil;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;

public class WorkloadIdentityCredential
implements TokenCredential {
    private static final ClientLogger LOGGER = new ClientLogger(WorkloadIdentityCredential.class);
    private final IdentityClient identityClient;
    private final IdentitySyncClient identitySyncClient;
    private final IdentityClientOptions identityClientOptions;

    WorkloadIdentityCredential(String string, String string2, String string3, IdentityClientOptions identityClientOptions) {
        String string4;
        ValidationUtil.validateTenantIdCharacterRange(string, LOGGER);
        Configuration configuration = identityClientOptions.getConfiguration() == null ? Configuration.getGlobalConfiguration().clone() : identityClientOptions.getConfiguration();
        String string5 = CoreUtils.isNullOrEmpty(string) ? configuration.get("AZURE_TENANT_ID") : string;
        String string6 = CoreUtils.isNullOrEmpty(string3) ? configuration.get("AZURE_FEDERATED_TOKEN_FILE") : string3;
        String string7 = string4 = CoreUtils.isNullOrEmpty(string2) ? configuration.get("AZURE_CLIENT_ID") : string2;
        if (!(CoreUtils.isNullOrEmpty(string5) || CoreUtils.isNullOrEmpty(string6) || CoreUtils.isNullOrEmpty(string4) || CoreUtils.isNullOrEmpty(identityClientOptions.getAuthorityHost()))) {
            IdentityClientBuilder identityClientBuilder = new IdentityClientBuilder().clientAssertionPath(string6).clientId(string4).tenantId(string5).identityClientOptions(identityClientOptions);
            this.identityClient = identityClientBuilder.build();
            this.identitySyncClient = identityClientBuilder.buildSyncClient();
        } else {
            this.identityClient = null;
            this.identitySyncClient = null;
        }
        this.identityClientOptions = identityClientOptions;
    }

    @Override
    public Mono<AccessToken> getToken(TokenRequestContext tokenRequestContext) {
        if (this.identityClient == null) {
            return Mono.error((Throwable)LoggingUtil.logCredentialUnavailableException(LOGGER, this.identityClientOptions, new CredentialUnavailableException("WorkloadIdentityCredential authentication unavailable. The workload options are not fully configured. See the troubleshooting guide for more information. https://aka.ms/azsdk/java/identity/workloadidentitycredential/troubleshoot")));
        }
        return this.identityClient.authenticateWithWorkloadIdentityConfidentialClient(tokenRequestContext);
    }

    @Override
    public AccessToken getTokenSync(TokenRequestContext tokenRequestContext) {
        if (this.identitySyncClient == null) {
            throw LoggingUtil.logCredentialUnavailableException(LOGGER, this.identityClientOptions, new CredentialUnavailableException("WorkloadIdentityCredential authentication unavailable. The workload options are not fully configured. See the troubleshooting guide for more information. https://aka.ms/azsdk/java/identity/workloadidentitycredential/troubleshoot"));
        }
        return this.identitySyncClient.authenticateWithWorkloadIdentityConfidentialClient(tokenRequestContext);
    }

    String getClientId() {
        return this.identityClient.getClientId();
    }
}

