/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.identity;

import java.util.Arrays;
import java.util.List;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.AadCredentialBuilderBase;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.TokenCachePersistenceOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.UsernamePasswordCredential;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.util.IdentityUtil;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.util.ValidationUtil;

public class UsernamePasswordCredentialBuilder
extends AadCredentialBuilderBase<UsernamePasswordCredentialBuilder> {
    private static final ClientLogger LOGGER = new ClientLogger(UsernamePasswordCredentialBuilder.class);
    private static final String CLASS_NAME = UsernamePasswordCredentialBuilder.class.getSimpleName();
    private String username;
    private String password;

    public UsernamePasswordCredentialBuilder username(String string) {
        this.username = string;
        return this;
    }

    public UsernamePasswordCredentialBuilder password(String string) {
        this.password = string;
        return this;
    }

    public UsernamePasswordCredentialBuilder tokenCachePersistenceOptions(TokenCachePersistenceOptions tokenCachePersistenceOptions) {
        this.identityClientOptions.setTokenCacheOptions(tokenCachePersistenceOptions);
        return this;
    }

    UsernamePasswordCredentialBuilder allowUnencryptedCache() {
        this.identityClientOptions.setAllowUnencryptedCache(true);
        return this;
    }

    UsernamePasswordCredentialBuilder enablePersistentCache() {
        this.identityClientOptions.enablePersistentCache();
        return this;
    }

    @Override
    public UsernamePasswordCredentialBuilder additionallyAllowedTenants(String ... stringArray) {
        this.identityClientOptions.setAdditionallyAllowedTenants(IdentityUtil.resolveAdditionalTenants(Arrays.asList(stringArray)));
        return this;
    }

    @Override
    public UsernamePasswordCredentialBuilder additionallyAllowedTenants(List<String> list) {
        this.identityClientOptions.setAdditionallyAllowedTenants(IdentityUtil.resolveAdditionalTenants(list));
        return this;
    }

    public UsernamePasswordCredential build() {
        ValidationUtil.validate(CLASS_NAME, LOGGER, "clientId", this.clientId, "username", this.username, "password", this.password);
        return new UsernamePasswordCredential(this.clientId, this.tenantId, this.username, this.password, this.identityClientOptions);
    }
}

