/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.identity;

import java.util.concurrent.atomic.AtomicReference;
import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.AccessToken;
import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.TokenCredential;
import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.TokenRequestContext;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.Configuration;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.AuthenticationRecord;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.CredentialUnavailableException;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.IdentityClient;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.IdentityClientBuilder;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.IdentityClientOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.MsalAuthenticationAccount;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.MsalToken;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.util.LoggingUtil;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.util.ValidationUtil;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;

public class SharedTokenCacheCredential
implements TokenCredential {
    private static final ClientLogger LOGGER = new ClientLogger(SharedTokenCacheCredential.class);
    private final String username;
    private final String clientId;
    private final String tenantId;
    private final AtomicReference<MsalAuthenticationAccount> cachedToken;
    private final IdentityClient identityClient;

    SharedTokenCacheCredential(String string, String string2, String string3, IdentityClientOptions identityClientOptions) {
        Configuration configuration = identityClientOptions.getConfiguration() == null ? Configuration.getGlobalConfiguration().clone() : identityClientOptions.getConfiguration();
        this.username = string == null ? configuration.get("AZURE_USERNAME") : string;
        this.clientId = string2 == null ? configuration.get("AZURE_CLIENT_ID") : string2;
        if (string3 == null) {
            this.tenantId = configuration.contains("AZURE_TENANT_ID") ? configuration.get("AZURE_TENANT_ID") : "common";
            ValidationUtil.validateTenantIdCharacterRange(this.tenantId, LOGGER);
        } else {
            this.tenantId = string3;
        }
        this.identityClient = new IdentityClientBuilder().tenantId(this.tenantId).clientId(this.clientId).sharedTokenCacheCredential(true).identityClientOptions(identityClientOptions).build();
        this.cachedToken = new AtomicReference();
        if (identityClientOptions.getAuthenticationRecord() != null) {
            this.cachedToken.set(new MsalAuthenticationAccount(identityClientOptions.getAuthenticationRecord()));
        }
        LoggingUtil.logAvailableEnvironmentVariables(LOGGER, configuration);
    }

    @Override
    public Mono<AccessToken> getToken(TokenRequestContext tokenRequestContext) {
        return Mono.defer(() -> {
            if (this.cachedToken.get() != null) {
                return this.identityClient.authenticateWithPublicClientCache(tokenRequestContext, this.cachedToken.get()).onErrorResume(throwable -> Mono.empty());
            }
            return Mono.empty();
        }).switchIfEmpty(Mono.defer(() -> this.identityClient.authenticateWithSharedTokenCache(tokenRequestContext, this.username))).map(this::updateCache).doOnNext(accessToken -> LoggingUtil.logTokenSuccess(LOGGER, tokenRequestContext)).doOnError(throwable -> LoggingUtil.logTokenError(LOGGER, this.identityClient.getIdentityClientOptions(), tokenRequestContext, throwable)).onErrorMap(throwable -> {
            if (this.identityClient.getIdentityClientOptions().isChained()) {
                return new CredentialUnavailableException(throwable.getMessage(), (Throwable)throwable);
            }
            return throwable;
        });
    }

    private AccessToken updateCache(MsalToken msalToken) {
        this.cachedToken.set(new MsalAuthenticationAccount(new AuthenticationRecord(msalToken.getAuthenticationResult(), this.identityClient.getTenantId(), this.identityClient.getClientId())));
        return msalToken;
    }
}

