/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.identity;

import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.AccessToken;
import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.TokenCredential;
import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.TokenRequestContext;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.IdentityClient;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.IdentityClientBuilder;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.IdentityClientOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.IdentitySyncClient;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.util.LoggingUtil;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;

public class OnBehalfOfCredential
implements TokenCredential {
    private static final ClientLogger LOGGER = new ClientLogger(OnBehalfOfCredential.class);
    private final IdentityClient identityClient;
    private final IdentitySyncClient identitySyncClient;

    OnBehalfOfCredential(String string, String string2, String string3, String string4, String string5, IdentityClientOptions identityClientOptions) {
        IdentityClientBuilder identityClientBuilder = new IdentityClientBuilder().tenantId(string2).clientId(string).clientSecret(string3).certificatePath(string4).certificatePassword(string5).identityClientOptions(identityClientOptions);
        this.identitySyncClient = identityClientBuilder.buildSyncClient();
        this.identityClient = identityClientBuilder.build();
    }

    @Override
    public Mono<AccessToken> getToken(TokenRequestContext tokenRequestContext) {
        return Mono.deferContextual(contextView -> this.identityClient.authenticateWithConfidentialClientCache(tokenRequestContext).onErrorResume(throwable -> Mono.empty()).switchIfEmpty(Mono.defer(() -> this.identityClient.authenticateWithOBO(tokenRequestContext))).doOnNext(accessToken -> LoggingUtil.logTokenSuccess(LOGGER, tokenRequestContext)).doOnError(throwable -> LoggingUtil.logTokenError(LOGGER, this.identityClient.getIdentityClientOptions(), tokenRequestContext, throwable)));
    }

    @Override
    public AccessToken getTokenSync(TokenRequestContext tokenRequestContext) {
        AccessToken accessToken;
        try {
            accessToken = this.identitySyncClient.authenticateWithConfidentialClientCache(tokenRequestContext);
            if (accessToken != null) {
                LoggingUtil.logTokenSuccess(LOGGER, tokenRequestContext);
                return accessToken;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            accessToken = this.identitySyncClient.authenticateWithOBO(tokenRequestContext);
            LoggingUtil.logTokenSuccess(LOGGER, tokenRequestContext);
            return accessToken;
        }
        catch (Exception exception) {
            LoggingUtil.logTokenError(LOGGER, this.identityClient.getIdentityClientOptions(), tokenRequestContext, exception);
            throw exception;
        }
    }
}

