/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.identity;

import java.time.Duration;
import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.AccessToken;
import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.TokenCredential;
import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.TokenRequestContext;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.Configuration;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.AksExchangeTokenCredential;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.AppServiceMsiCredential;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.ArcIdentityCredential;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.CredentialUnavailableException;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.ManagedIdentityServiceCredential;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.ServiceFabricMsiCredential;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.VirtualMachineMsiCredential;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.IdentityClientBuilder;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.IdentityClientOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.ManagedIdentityParameters;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.ManagedIdentityType;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.util.LoggingUtil;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;

public final class ManagedIdentityCredential
implements TokenCredential {
    private static final ClientLogger LOGGER = new ClientLogger(ManagedIdentityCredential.class);
    final ManagedIdentityServiceCredential managedIdentityServiceCredential;
    private final IdentityClientOptions identityClientOptions;
    static final String PROPERTY_IMDS_ENDPOINT = "IMDS_ENDPOINT";
    static final String PROPERTY_IDENTITY_SERVER_THUMBPRINT = "IDENTITY_SERVER_THUMBPRINT";
    static final String AZURE_FEDERATED_TOKEN_FILE = "AZURE_FEDERATED_TOKEN_FILE";

    ManagedIdentityCredential(String string, String string2, IdentityClientOptions identityClientOptions) {
        Configuration configuration;
        IdentityClientBuilder identityClientBuilder = new IdentityClientBuilder().clientId(string).resourceId(string2).identityClientOptions(identityClientOptions);
        this.identityClientOptions = identityClientOptions;
        Configuration configuration2 = configuration = identityClientOptions.getConfiguration() == null ? Configuration.getGlobalConfiguration().clone() : identityClientOptions.getConfiguration();
        if (configuration.contains("MSI_ENDPOINT")) {
            this.managedIdentityServiceCredential = new AppServiceMsiCredential(string, identityClientBuilder.identityClientOptions(this.updateIdentityClientOptions(ManagedIdentityType.APP_SERVICE, identityClientOptions, configuration)).build());
        } else if (configuration.contains("IDENTITY_ENDPOINT")) {
            this.managedIdentityServiceCredential = configuration.contains("IDENTITY_HEADER") ? (configuration.get(PROPERTY_IDENTITY_SERVER_THUMBPRINT) != null ? new ServiceFabricMsiCredential(string, identityClientBuilder.identityClientOptions(this.updateIdentityClientOptions(ManagedIdentityType.SERVICE_FABRIC, identityClientOptions, configuration)).build()) : new AppServiceMsiCredential(string, identityClientBuilder.identityClientOptions(this.updateIdentityClientOptions(ManagedIdentityType.APP_SERVICE, identityClientOptions, configuration)).build())) : (configuration.get(PROPERTY_IMDS_ENDPOINT) != null ? new ArcIdentityCredential(string, identityClientBuilder.identityClientOptions(this.updateIdentityClientOptions(ManagedIdentityType.ARC, identityClientOptions, configuration)).build()) : new VirtualMachineMsiCredential(string, identityClientBuilder.identityClientOptions(this.updateIdentityClientOptions(ManagedIdentityType.VM, identityClientOptions, configuration)).build()));
        } else if (configuration.contains("AZURE_TENANT_ID") && configuration.get(AZURE_FEDERATED_TOKEN_FILE) != null) {
            String string3 = string == null ? configuration.get("AZURE_CLIENT_ID") : string;
            identityClientBuilder.clientId(string3);
            identityClientBuilder.tenantId(configuration.get("AZURE_TENANT_ID"));
            identityClientBuilder.clientAssertionPath(configuration.get(AZURE_FEDERATED_TOKEN_FILE));
            identityClientBuilder.clientAssertionTimeout(Duration.ofMinutes(5L));
            this.managedIdentityServiceCredential = new AksExchangeTokenCredential(string3, identityClientBuilder.identityClientOptions(this.updateIdentityClientOptions(ManagedIdentityType.AKS, identityClientOptions, configuration)).build());
        } else {
            this.managedIdentityServiceCredential = new VirtualMachineMsiCredential(string, identityClientBuilder.identityClientOptions(this.updateIdentityClientOptions(ManagedIdentityType.VM, identityClientOptions, configuration)).build());
        }
        LoggingUtil.logAvailableEnvironmentVariables(LOGGER, configuration);
    }

    private IdentityClientOptions updateIdentityClientOptions(ManagedIdentityType managedIdentityType, IdentityClientOptions identityClientOptions, Configuration configuration) {
        switch (managedIdentityType) {
            case APP_SERVICE: {
                return identityClientOptions.setManagedIdentityType(ManagedIdentityType.APP_SERVICE).setManagedIdentityParameters(new ManagedIdentityParameters().setMsiEndpoint(configuration.get("MSI_ENDPOINT")).setMsiSecret(configuration.get("MSI_SECRET")).setIdentityEndpoint(configuration.get("IDENTITY_ENDPOINT")).setIdentityHeader(configuration.get("IDENTITY_HEADER")));
            }
            case SERVICE_FABRIC: {
                return identityClientOptions.setManagedIdentityType(ManagedIdentityType.SERVICE_FABRIC).setManagedIdentityParameters(new ManagedIdentityParameters().setIdentityServerThumbprint(configuration.get(PROPERTY_IDENTITY_SERVER_THUMBPRINT)).setIdentityEndpoint(configuration.get("IDENTITY_ENDPOINT")).setIdentityHeader(configuration.get("IDENTITY_HEADER")));
            }
            case ARC: {
                return identityClientOptions.setManagedIdentityType(ManagedIdentityType.ARC).setManagedIdentityParameters(new ManagedIdentityParameters().setIdentityEndpoint(configuration.get("IDENTITY_ENDPOINT")));
            }
            case VM: {
                return identityClientOptions.setManagedIdentityType(ManagedIdentityType.VM);
            }
            case AKS: {
                return identityClientOptions.setManagedIdentityType(ManagedIdentityType.AKS);
            }
        }
        return identityClientOptions;
    }

    public String getClientId() {
        return this.managedIdentityServiceCredential.getClientId();
    }

    @Override
    public Mono<AccessToken> getToken(TokenRequestContext tokenRequestContext) {
        if (this.managedIdentityServiceCredential == null) {
            return Mono.error((Throwable)LoggingUtil.logCredentialUnavailableException(LOGGER, this.identityClientOptions, new CredentialUnavailableException("ManagedIdentityCredential authentication unavailable. The Target Azure platform could not be determined from environment variables.To mitigate this issue, please refer to the troubleshooting guidelines here at https://aka.ms/azsdk/java/identity/managedidentitycredential/troubleshoot")));
        }
        return this.managedIdentityServiceCredential.authenticate(tokenRequestContext).doOnSuccess(accessToken -> LOGGER.info("Azure Identity => Managed Identity environment: {}", this.managedIdentityServiceCredential.getEnvironment())).doOnNext(accessToken -> LoggingUtil.logTokenSuccess(LOGGER, tokenRequestContext)).doOnError(throwable -> LoggingUtil.logTokenError(LOGGER, this.identityClientOptions, tokenRequestContext, throwable));
    }
}

