/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.identity;

import java.util.concurrent.atomic.AtomicReference;
import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.AccessToken;
import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.TokenCredential;
import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.TokenRequestContext;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.CredentialUnavailableException;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.IdentityClient;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.IdentityClientBuilder;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.IdentityClientOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.IntelliJAuthMethodDetails;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.IntelliJCacheAccessor;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.MsalToken;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.util.LoggingUtil;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;

public class IntelliJCredential
implements TokenCredential {
    private static final ClientLogger LOGGER = new ClientLogger(IntelliJCredential.class);
    private static final String AZURE_TOOLS_FOR_INTELLIJ_CLIENT_ID = "61d65f5a-6e3b-468b-af73-a033f5098c5c";
    private final IdentityClient identityClient;
    private final AtomicReference<MsalToken> cachedToken;

    IntelliJCredential(String string, IdentityClientOptions identityClientOptions) {
        String string2;
        IntelliJAuthMethodDetails intelliJAuthMethodDetails;
        IdentityClientOptions identityClientOptions2 = identityClientOptions == null ? new IdentityClientOptions() : identityClientOptions;
        IntelliJCacheAccessor intelliJCacheAccessor = new IntelliJCacheAccessor(identityClientOptions2.getIntelliJKeePassDatabasePath());
        try {
            intelliJAuthMethodDetails = intelliJCacheAccessor.getAuthDetailsIfAvailable();
        }
        catch (Exception exception) {
            intelliJAuthMethodDetails = null;
        }
        if (CoreUtils.isNullOrEmpty(identityClientOptions2.getAuthorityHost())) {
            string2 = intelliJAuthMethodDetails != null ? intelliJAuthMethodDetails.getAzureEnv() : "";
            String string3 = intelliJCacheAccessor.getAzureAuthHost(string2);
            identityClientOptions2.setAuthorityHost(string3);
        }
        if ((string2 = string) == null) {
            string2 = "common";
        }
        this.identityClient = new IdentityClientBuilder().identityClientOptions(identityClientOptions2).tenantId(string2).clientId("04b07795-8ddb-461a-bbee-02f9e1bf7b46").build();
        this.cachedToken = new AtomicReference();
    }

    @Override
    public Mono<AccessToken> getToken(TokenRequestContext tokenRequestContext) {
        return Mono.defer(() -> {
            if (this.cachedToken.get() != null) {
                return this.identityClient.authenticateWithPublicClientCache(tokenRequestContext, this.cachedToken.get().getAccount()).onErrorResume(throwable -> Mono.empty());
            }
            return Mono.empty();
        }).switchIfEmpty(Mono.defer(() -> this.identityClient.authenticateWithIntelliJ(tokenRequestContext))).map(msalToken -> {
            this.cachedToken.set((MsalToken)msalToken);
            return msalToken;
        }).doOnNext(accessToken -> LoggingUtil.logTokenSuccess(LOGGER, tokenRequestContext)).doOnError(throwable -> LoggingUtil.logTokenError(LOGGER, this.identityClient.getIdentityClientOptions(), tokenRequestContext, throwable)).onErrorMap(throwable -> {
            if (this.identityClient.getIdentityClientOptions().isChained()) {
                return new CredentialUnavailableException(throwable.getMessage(), (Throwable)throwable);
            }
            return throwable;
        });
    }
}

