/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.identity;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.TokenCredential;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.Configuration;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.AzureCliCredential;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.AzureDeveloperCliCredential;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.AzurePowerShellCredential;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.CredentialBuilderBase;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.DefaultAzureCredential;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.EnvironmentCredential;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.IntelliJCredential;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.ManagedIdentityCredential;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.SharedTokenCacheCredential;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.WorkloadIdentityCredential;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.IdentityLogOptionsImpl;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.util.IdentityUtil;

public class DefaultAzureCredentialBuilder
extends CredentialBuilderBase<DefaultAzureCredentialBuilder> {
    private static final ClientLogger LOGGER = new ClientLogger(DefaultAzureCredentialBuilder.class);
    private String tenantId;
    private String managedIdentityClientId;
    private String workloadIdentityClientId;
    private String managedIdentityResourceId;
    private List<String> additionallyAllowedTenants = IdentityUtil.getAdditionalTenantsFromEnvironment(Configuration.getGlobalConfiguration().clone());

    public DefaultAzureCredentialBuilder() {
        this.identityClientOptions.setIdentityLogOptionsImpl(new IdentityLogOptionsImpl(true));
        this.identityClientOptions.setChained(true);
    }

    public DefaultAzureCredentialBuilder tenantId(String string) {
        this.tenantId = string;
        return this;
    }

    public DefaultAzureCredentialBuilder authorityHost(String string) {
        this.identityClientOptions.setAuthorityHost(string);
        return this;
    }

    public DefaultAzureCredentialBuilder intelliJKeePassDatabasePath(String string) {
        if (CoreUtils.isNullOrEmpty(string)) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("The KeePass database path is either empty or not configured. Please configure it on the builder."));
        }
        this.identityClientOptions.setIntelliJKeePassDatabasePath(string);
        return this;
    }

    public DefaultAzureCredentialBuilder managedIdentityClientId(String string) {
        this.managedIdentityClientId = string;
        return this;
    }

    public DefaultAzureCredentialBuilder workloadIdentityClientId(String string) {
        this.workloadIdentityClientId = string;
        return this;
    }

    public DefaultAzureCredentialBuilder managedIdentityResourceId(String string) {
        this.managedIdentityResourceId = string;
        return this;
    }

    public DefaultAzureCredentialBuilder executorService(ExecutorService executorService) {
        this.identityClientOptions.setExecutorService(executorService);
        return this;
    }

    public DefaultAzureCredentialBuilder additionallyAllowedTenants(String ... stringArray) {
        this.additionallyAllowedTenants = IdentityUtil.resolveAdditionalTenants(Arrays.asList(stringArray));
        return this;
    }

    public DefaultAzureCredentialBuilder additionallyAllowedTenants(List<String> list) {
        this.additionallyAllowedTenants = IdentityUtil.resolveAdditionalTenants(list);
        return this;
    }

    public DefaultAzureCredentialBuilder credentialProcessTimeout(Duration duration) {
        Objects.requireNonNull(duration);
        this.identityClientOptions.setCredentialProcessTimeout(duration);
        return this;
    }

    public DefaultAzureCredentialBuilder disableInstanceDiscovery() {
        this.identityClientOptions.disableInstanceDiscovery();
        return this;
    }

    public DefaultAzureCredential build() {
        this.loadFallbackValuesFromEnvironment();
        if (this.managedIdentityClientId != null && this.managedIdentityResourceId != null) {
            throw LOGGER.logExceptionAsError(new IllegalStateException("Only one of managedIdentityResourceId and managedIdentityClientId can be specified."));
        }
        if (!CoreUtils.isNullOrEmpty(this.additionallyAllowedTenants)) {
            this.identityClientOptions.setAdditionallyAllowedTenants(this.additionallyAllowedTenants);
        }
        return new DefaultAzureCredential(this.getCredentialsChain());
    }

    private void loadFallbackValuesFromEnvironment() {
        Configuration configuration = this.identityClientOptions.getConfiguration() == null ? Configuration.getGlobalConfiguration().clone() : this.identityClientOptions.getConfiguration();
        this.tenantId = CoreUtils.isNullOrEmpty(this.tenantId) ? configuration.get("AZURE_TENANT_ID") : this.tenantId;
        this.managedIdentityClientId = CoreUtils.isNullOrEmpty(this.managedIdentityClientId) ? configuration.get("AZURE_CLIENT_ID") : this.managedIdentityClientId;
    }

    private ArrayList<TokenCredential> getCredentialsChain() {
        ArrayList<TokenCredential> arrayList = new ArrayList<TokenCredential>(8);
        arrayList.add(new EnvironmentCredential(this.identityClientOptions.clone()));
        arrayList.add(this.getWorkloadIdentityCredential());
        arrayList.add(new ManagedIdentityCredential(this.managedIdentityClientId, this.managedIdentityResourceId, this.identityClientOptions.clone()));
        arrayList.add(new SharedTokenCacheCredential(null, "04b07795-8ddb-461a-bbee-02f9e1bf7b46", this.tenantId, this.identityClientOptions.clone()));
        arrayList.add(new IntelliJCredential(this.tenantId, this.identityClientOptions.clone()));
        arrayList.add(new AzureCliCredential(this.tenantId, this.identityClientOptions.clone()));
        arrayList.add(new AzurePowerShellCredential(this.tenantId, this.identityClientOptions.clone()));
        arrayList.add(new AzureDeveloperCliCredential(this.tenantId, this.identityClientOptions.clone()));
        return arrayList;
    }

    private WorkloadIdentityCredential getWorkloadIdentityCredential() {
        String string;
        Configuration configuration = this.identityClientOptions.getConfiguration() == null ? Configuration.getGlobalConfiguration().clone() : this.identityClientOptions.getConfiguration();
        String string2 = configuration.get("AZURE_AUTHORITY_HOST");
        String string3 = string = CoreUtils.isNullOrEmpty(this.workloadIdentityClientId) ? this.managedIdentityClientId : this.workloadIdentityClientId;
        if (!CoreUtils.isNullOrEmpty(string2)) {
            this.identityClientOptions.setAuthorityHost(string2);
        }
        return new WorkloadIdentityCredential(this.tenantId, string, null, this.identityClientOptions.clone());
    }
}

