/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.identity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.AccessToken;
import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.TokenCredential;
import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.TokenRequestContext;
import macromedia.jdbc.sqlserver.externals.com.azure.core.exception.ClientAuthenticationException;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.CredentialUnavailableException;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.WorkloadIdentityCredential;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Flux;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;

public class ChainedTokenCredential
implements TokenCredential {
    private static final ClientLogger LOGGER = new ClientLogger(ChainedTokenCredential.class);
    private final List<TokenCredential> credentials;
    private final String unavailableError = this.getClass().getSimpleName() + " authentication failed. ---> ";
    private final AtomicReference<TokenCredential> selectedCredential;
    private boolean useCachedWorkingCredential = false;

    ChainedTokenCredential(List<TokenCredential> list) {
        this.credentials = Collections.unmodifiableList(list);
        this.selectedCredential = new AtomicReference();
    }

    @Override
    public Mono<AccessToken> getToken(TokenRequestContext tokenRequestContext) {
        ArrayList arrayList = new ArrayList(4);
        Mono mono = this.selectedCredential.get() != null && this.useCachedWorkingCredential ? Mono.defer(() -> this.selectedCredential.get().getToken(tokenRequestContext).doOnNext(accessToken -> this.logTokenMessage("Azure Identity => Returning token from cached credential {}", this.selectedCredential.get())).onErrorResume(Exception.class, this.handleExceptionAsync(arrayList, this.selectedCredential.get(), "Azure Identity => Cached credential {} is unavailable."))) : Flux.fromIterable(this.credentials).flatMap(tokenCredential -> tokenCredential.getToken(tokenRequestContext).doOnNext(accessToken -> {
            this.logTokenMessage("Azure Identity => Attempted credential {} returns a token", (TokenCredential)tokenCredential);
            this.selectedCredential.set((TokenCredential)tokenCredential);
        }).onErrorResume(Exception.class, this.handleExceptionAsync(arrayList, (TokenCredential)tokenCredential, "Azure Identity => Attempted credential {} is unavailable.")), 1).next();
        return mono.switchIfEmpty(Mono.defer(() -> {
            CredentialUnavailableException credentialUnavailableException = (CredentialUnavailableException)arrayList.get(arrayList.size() - 1);
            for (int i2 = arrayList.size() - 2; i2 >= 0; --i2) {
                CredentialUnavailableException credentialUnavailableException2 = (CredentialUnavailableException)arrayList.get(i2);
                credentialUnavailableException = new CredentialUnavailableException(credentialUnavailableException2.getMessage() + "\r\n" + credentialUnavailableException.getMessage() + (i2 == 0 ? "To mitigate this issue, please refer to the troubleshooting guidelines here at https://aka.ms/azure-identity-java-default-azure-credential-troubleshoot" : ""));
            }
            return Mono.error((Throwable)credentialUnavailableException);
        }));
    }

    private Function<Exception, Mono<? extends AccessToken>> handleExceptionAsync(List<CredentialUnavailableException> list, TokenCredential tokenCredential, String string) {
        return exception -> {
            if (!exception.getClass().getSimpleName().equals("CredentialUnavailableException")) {
                return Mono.error((Throwable)new ClientAuthenticationException(this.getCredUnavailableMessage(tokenCredential, (Exception)exception), null, (Throwable)exception));
            }
            list.add((CredentialUnavailableException)exception);
            this.logTokenMessage(string, tokenCredential);
            return Mono.empty();
        };
    }

    @Override
    public AccessToken getTokenSync(TokenRequestContext tokenRequestContext) {
        ArrayList<CredentialUnavailableException> arrayList = new ArrayList<CredentialUnavailableException>(4);
        if (this.selectedCredential.get() != null && this.useCachedWorkingCredential) {
            try {
                AccessToken accessToken = this.selectedCredential.get().getTokenSync(tokenRequestContext);
                this.logTokenMessage("Azure Identity => Returning token from cached credential {}", this.selectedCredential.get());
                return accessToken;
            }
            catch (Exception exception) {
                this.handleExceptionSync(exception, this.selectedCredential.get(), arrayList, "Azure Identity => Cached credential {} is unavailable.", this.selectedCredential.get());
            }
        } else {
            for (TokenCredential tokenCredential : this.credentials) {
                try {
                    AccessToken accessToken = tokenCredential.getTokenSync(tokenRequestContext);
                    this.logTokenMessage("Azure Identity => Attempted credential {} returns a token", tokenCredential);
                    this.selectedCredential.set(tokenCredential);
                    return accessToken;
                }
                catch (Exception exception) {
                    this.handleExceptionSync(exception, tokenCredential, arrayList, "Azure Identity => Attempted credential {} is unavailable.", tokenCredential);
                }
            }
        }
        Object object = (CredentialUnavailableException)arrayList.get(arrayList.size() - 1);
        for (int i2 = arrayList.size() - 2; i2 >= 0; --i2) {
            CredentialUnavailableException credentialUnavailableException = (CredentialUnavailableException)arrayList.get(i2);
            object = new CredentialUnavailableException(credentialUnavailableException.getMessage() + "\r\n" + ((Throwable)object).getMessage() + (i2 == 0 ? "To mitigate this issue, please refer to the troubleshooting guidelines here at https://aka.ms/azure-identity-java-default-azure-credential-troubleshoot" : ""));
        }
        throw object;
    }

    private void logTokenMessage(String string, TokenCredential tokenCredential) {
        LOGGER.info(string, tokenCredential.getClass().getSimpleName());
    }

    private String getCredUnavailableMessage(TokenCredential tokenCredential, Exception exception) {
        return this.unavailableError + tokenCredential.getClass().getSimpleName() + " authentication failed. Error Details: " + exception.getMessage();
    }

    private void handleExceptionSync(Exception exception, TokenCredential tokenCredential, List<CredentialUnavailableException> list, String string, TokenCredential tokenCredential2) {
        if (exception.getClass() != CredentialUnavailableException.class) {
            throw new ClientAuthenticationException(this.getCredUnavailableMessage(tokenCredential, exception), null, exception);
        }
        if (exception instanceof CredentialUnavailableException) {
            list.add((CredentialUnavailableException)exception);
        }
        this.logTokenMessage(string, tokenCredential2);
    }

    WorkloadIdentityCredential getWorkloadIdentityCredentialIfPresent() {
        List list = this.credentials.stream().filter(tokenCredential -> tokenCredential instanceof WorkloadIdentityCredential).collect(Collectors.toList());
        if (list.size() == 1) {
            return (WorkloadIdentityCredential)list.get(0);
        }
        return null;
    }

    void enableUseCachedWorkingCredential() {
        this.useCachedWorkingCredential = true;
    }
}

