/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.identity;

import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.AzureDeveloperCliCredential;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.CredentialBuilderBase;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.util.IdentityUtil;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.util.ValidationUtil;

public class AzureDeveloperCliCredentialBuilder
extends CredentialBuilderBase<AzureDeveloperCliCredentialBuilder> {
    private static final ClientLogger LOGGER = new ClientLogger(AzureDeveloperCliCredentialBuilder.class);
    private String tenantId;

    public AzureDeveloperCliCredentialBuilder tenantId(String string) {
        ValidationUtil.validateTenantIdCharacterRange(string, LOGGER);
        this.tenantId = string;
        return this;
    }

    public AzureDeveloperCliCredentialBuilder processTimeout(Duration duration) {
        Objects.requireNonNull(duration);
        this.identityClientOptions.setCredentialProcessTimeout(duration);
        return this;
    }

    public AzureDeveloperCliCredential build() {
        return new AzureDeveloperCliCredential(this.tenantId, this.identityClientOptions);
    }

    public AzureDeveloperCliCredentialBuilder additionallyAllowedTenants(String ... stringArray) {
        this.identityClientOptions.setAdditionallyAllowedTenants(IdentityUtil.resolveAdditionalTenants(Arrays.asList(stringArray)));
        return this;
    }

    public AzureDeveloperCliCredentialBuilder additionallyAllowedTenants(List<String> list) {
        this.identityClientOptions.setAdditionallyAllowedTenants(IdentityUtil.resolveAdditionalTenants(list));
        return this;
    }
}

