/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.identity;

import java.net.URI;
import java.util.concurrent.atomic.AtomicReference;
import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.AccessToken;
import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.TokenCredential;
import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.TokenRequestContext;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.AuthenticationRecord;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.IdentityClient;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.IdentityClientBuilder;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.IdentityClientOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.MsalAuthenticationAccount;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.MsalToken;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.util.LoggingUtil;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;

public class AuthorizationCodeCredential
implements TokenCredential {
    private static final ClientLogger LOGGER = new ClientLogger(AuthorizationCodeCredential.class);
    private final String authCode;
    private final URI redirectUri;
    private final IdentityClient identityClient;
    private final AtomicReference<MsalAuthenticationAccount> cachedToken;
    private boolean isCaeEnabledRequestCached;
    private boolean isCaeDisabledRequestCached;
    private boolean isCachePopulated;
    private final boolean useConfidentialClient;

    AuthorizationCodeCredential(String string, String string2, String string3, String string4, URI uRI, IdentityClientOptions identityClientOptions) {
        this.identityClient = new IdentityClientBuilder().tenantId(string3).clientId(string).clientSecret(string2).identityClientOptions(identityClientOptions).build();
        this.cachedToken = new AtomicReference();
        this.authCode = string4;
        this.redirectUri = uRI;
        this.useConfidentialClient = !CoreUtils.isNullOrEmpty(string2);
    }

    @Override
    public Mono<AccessToken> getToken(TokenRequestContext tokenRequestContext) {
        return Mono.defer(() -> {
            this.isCachePopulated = this.isCachePopulated(tokenRequestContext);
            if (this.isCachePopulated) {
                if (this.useConfidentialClient) {
                    return this.identityClient.authenticateWithConfidentialClientCache(tokenRequestContext, this.cachedToken.get()).map(accessToken -> (MsalToken)accessToken);
                }
                return this.identityClient.authenticateWithPublicClientCache(tokenRequestContext, this.cachedToken.get()).onErrorResume(throwable -> Mono.empty());
            }
            return Mono.empty();
        }).switchIfEmpty(Mono.defer(() -> this.identityClient.authenticateWithAuthorizationCode(tokenRequestContext, this.authCode, this.redirectUri))).map(msalToken -> {
            this.cachedToken.set(new MsalAuthenticationAccount(new AuthenticationRecord(msalToken.getAuthenticationResult(), this.identityClient.getTenantId(), this.identityClient.getClientId())));
            if (tokenRequestContext.isCaeEnabled()) {
                this.isCaeEnabledRequestCached = true;
            } else {
                this.isCaeDisabledRequestCached = true;
            }
            return msalToken;
        }).doOnNext(accessToken -> LoggingUtil.logTokenSuccess(LOGGER, tokenRequestContext)).doOnError(throwable -> LoggingUtil.logTokenError(LOGGER, this.identityClient.getIdentityClientOptions(), tokenRequestContext, throwable));
    }

    private boolean isCachePopulated(TokenRequestContext tokenRequestContext) {
        return this.cachedToken.get() != null && (tokenRequestContext.isCaeEnabled() && this.isCaeEnabledRequestCached || !tokenRequestContext.isCaeEnabled() && this.isCaeDisabledRequestCached);
    }
}

