/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.identity;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.CredentialBuilderBase;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.util.IdentityUtil;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.util.ValidationUtil;

public abstract class AadCredentialBuilderBase<T extends AadCredentialBuilderBase<T>>
extends CredentialBuilderBase<T> {
    private static final ClientLogger LOGGER = new ClientLogger(AadCredentialBuilderBase.class);
    String clientId;
    String tenantId;

    public T authorityHost(String string) {
        ValidationUtil.validateAuthHost(string, LOGGER);
        this.identityClientOptions.setAuthorityHost(string);
        return (T)this;
    }

    public T clientId(String string) {
        this.clientId = string;
        return (T)this;
    }

    public T tenantId(String string) {
        ValidationUtil.validateTenantIdCharacterRange(string, LOGGER);
        this.tenantId = string;
        return (T)this;
    }

    public T executorService(ExecutorService executorService) {
        this.identityClientOptions.setExecutorService(executorService);
        return (T)this;
    }

    public T additionallyAllowedTenants(String ... stringArray) {
        this.identityClientOptions.setAdditionallyAllowedTenants(IdentityUtil.resolveAdditionalTenants(Arrays.asList(stringArray)));
        return (T)this;
    }

    public T additionallyAllowedTenants(List<String> list) {
        this.identityClientOptions.setAdditionallyAllowedTenants(IdentityUtil.resolveAdditionalTenants(list));
        return (T)this;
    }

    public T disableInstanceDiscovery() {
        this.identityClientOptions.disableInstanceDiscovery();
        return (T)this;
    }

    public T enableUnsafeSupportLogging() {
        this.identityClientOptions.enableUnsafeSupportLogging();
        return (T)this;
    }
}

