/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.util.tracing;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Function;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.Context;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.tracing.NoopTracer;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.tracing.ProcessKind;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.tracing.SpanKind;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.tracing.StartSpanOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.tracing.TracingLink;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.tracing.Utils;

public interface Tracer {
    @Deprecated
    public static final String PARENT_SPAN_KEY = "parent-span";
    public static final String PARENT_TRACE_CONTEXT_KEY = "trace-context";
    @Deprecated
    public static final String USER_SPAN_NAME_KEY = "user-span-name";
    public static final String ENTITY_PATH_KEY = "entity-path";
    public static final String HOST_NAME_KEY = "hostname";
    public static final String SPAN_CONTEXT_KEY = "span-context";
    @Deprecated
    public static final String DIAGNOSTIC_ID_KEY = "Diagnostic-Id";
    @Deprecated
    public static final String SCOPE_KEY = "scope";
    @Deprecated
    public static final String AZ_TRACING_NAMESPACE_KEY = "az.namespace";
    @Deprecated
    public static final String SPAN_BUILDER_KEY = "builder";
    @Deprecated
    public static final String MESSAGE_ENQUEUED_TIME = "x-opt-enqueued-time";
    public static final String DISABLE_TRACING_KEY = "disable-tracing";

    public Context start(String var1, Context var2);

    default public Context start(String string, StartSpanOptions startSpanOptions, Context context) {
        return this.start(string, context);
    }

    @Deprecated
    default public Context start(String string3, Context context, ProcessKind processKind) {
        Objects.requireNonNull(string3, "'spanName' cannot be null.");
        Objects.requireNonNull(context, "'context' cannot be null.");
        Objects.requireNonNull(processKind, "'processKind' cannot be null.");
        if (!this.isEnabled()) {
            return context;
        }
        switch (processKind) {
            case SEND: {
                StartSpanOptions startSpanOptions = Utils.getOrNull(context, SPAN_BUILDER_KEY, StartSpanOptions.class);
                if (startSpanOptions == null) {
                    Utils.LOGGER.atWarning().addKeyValue("spanName", string3).addKeyValue("processKind", (Object)processKind).log("Start span is called without builder on the context, creating default builder.");
                    startSpanOptions = new StartSpanOptions(SpanKind.CLIENT);
                }
                Utils.addMessagingAttributes(startSpanOptions, context);
                return this.start(string3, startSpanOptions, context);
            }
            case MESSAGE: {
                StartSpanOptions startSpanOptions = new StartSpanOptions(SpanKind.PRODUCER);
                Utils.addMessagingAttributes(startSpanOptions, context);
                context = this.start(string3, startSpanOptions, context);
                AtomicReference atomicReference = new AtomicReference();
                this.injectContext((string, string2) -> {
                    if (string.equals("traceparent")) {
                        atomicReference.set(string2);
                    }
                }, context);
                return context.addData(DIAGNOSTIC_ID_KEY, atomicReference);
            }
            case PROCESS: {
                StartSpanOptions startSpanOptions = Utils.getOrNull(context, SPAN_BUILDER_KEY, StartSpanOptions.class);
                if (startSpanOptions == null) {
                    startSpanOptions = new StartSpanOptions(SpanKind.CONSUMER).setRemoteParent(context);
                }
                Utils.addMessagingAttributes(startSpanOptions, context);
                return this.start(string3, startSpanOptions, context);
            }
        }
        Utils.LOGGER.atWarning().addKeyValue("spanName", string3).addKeyValue("processKind", (Object)processKind).log("Start span is called with unknown process kind, suppressing the span.");
        return context;
    }

    @Deprecated
    default public void end(int n2, Throwable throwable, Context context) {
        this.end(null, throwable, context);
    }

    public void end(String var1, Throwable var2, Context var3);

    public void setAttribute(String var1, String var2, Context var3);

    default public void setAttribute(String string, long l2, Context context) {
        this.setAttribute(string, Long.toString(l2), context);
    }

    default public void setAttribute(String string, Object object, Context context) {
        Objects.requireNonNull(object, "'value' cannot be null.");
        this.setAttribute(string, object.toString(), context);
    }

    @Deprecated
    default public Context setSpanName(String string, Context context) {
        return context;
    }

    @Deprecated
    default public void addLink(Context context) {
        TracingLink tracingLink;
        if (!this.isEnabled()) {
            return;
        }
        StartSpanOptions startSpanOptions = Utils.getOrNull(context, SPAN_BUILDER_KEY, StartSpanOptions.class);
        if (startSpanOptions == null) {
            return;
        }
        Long l2 = Utils.getOrNull(context, MESSAGE_ENQUEUED_TIME, Long.class);
        if (l2 != null) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>(1);
            hashMap.put(MESSAGE_ENQUEUED_TIME, l2);
            tracingLink = new TracingLink(context, hashMap);
        } else {
            tracingLink = new TracingLink(context);
        }
        startSpanOptions.addLink(tracingLink);
    }

    @Deprecated
    default public Context extractContext(String string, Context context) {
        return this.extractContext(string2 -> {
            if (string2.equals("traceparent") || string2.equals(DIAGNOSTIC_ID_KEY)) {
                return string;
            }
            return null;
        });
    }

    default public Context extractContext(Function<String, String> function) {
        return Context.NONE;
    }

    default public void injectContext(BiConsumer<String, String> biConsumer, Context context) {
    }

    @Deprecated
    default public Context getSharedSpanBuilder(String string, Context context) {
        if (!this.isEnabled()) {
            return context;
        }
        SpanKind spanKind = Utils.getOrNull(context, "span-kind", SpanKind.class);
        if (spanKind == null) {
            spanKind = SpanKind.CLIENT;
        }
        StartSpanOptions startSpanOptions = new StartSpanOptions(spanKind);
        Instant instant = Utils.getOrNull(context, "span-start-time", Instant.class);
        if (instant != null) {
            startSpanOptions.setStartTimestamp(instant);
        }
        return context.addData(SPAN_BUILDER_KEY, startSpanOptions);
    }

    @Deprecated
    default public void addEvent(String string, Map<String, Object> map, OffsetDateTime offsetDateTime) {
        this.addEvent(string, map, offsetDateTime, Context.NONE);
    }

    default public void addEvent(String string, Map<String, Object> map, OffsetDateTime offsetDateTime, Context context) {
    }

    default public AutoCloseable makeSpanCurrent(Context context) {
        return NoopTracer.INSTANCE.makeSpanCurrent(context);
    }

    default public boolean isRecording(Context context) {
        return true;
    }

    default public boolean isEnabled() {
        return true;
    }
}

