/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.util.tracing;

import java.util.Iterator;
import java.util.Objects;
import java.util.ServiceLoader;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.util.Providers;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.TracingOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.LogLevel;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.tracing.NoopTracer;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.tracing.Tracer;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.tracing.TracerProvider;

final class DefaultTracerProvider
implements TracerProvider {
    private static final String NO_DEFAULT_PROVIDER = "A request was made to load the default TracerProvider provider but one could not be found on the classpath. If you are using a dependency manager, consider including a dependency on azure-core-tracing-opentelemetry or enabling instrumentation java agent.";
    private static final TracerProvider INSTANCE = new DefaultTracerProvider();
    private static final ClientLogger LOGGER = new ClientLogger(DefaultTracerProvider.class);
    private static final TracingOptions DEFAULT_OPTIONS = new TracingOptions();
    private static final Providers<TracerProvider, Tracer> TRACER_PROVIDERS = new Providers(TracerProvider.class, null, "A request was made to load the default TracerProvider provider but one could not be found on the classpath. If you are using a dependency manager, consider including a dependency on azure-core-tracing-opentelemetry or enabling instrumentation java agent.");
    private static final Tracer FALLBACK_TRACER = DefaultTracerProvider.createFallbackTracer();

    private DefaultTracerProvider() {
    }

    private static Tracer createFallbackTracer() {
        ServiceLoader<Tracer> serviceLoader = ServiceLoader.load(Tracer.class, Tracer.class.getClassLoader());
        Iterator<Tracer> iterator = serviceLoader.iterator();
        if (iterator.hasNext()) {
            Tracer tracer = iterator.next();
            LOGGER.log(LogLevel.INFORMATIONAL, () -> "Found Tracer implementation on the classpath: " + tracer.getClass().getName());
            return tracer;
        }
        return NoopTracer.INSTANCE;
    }

    static TracerProvider getInstance() {
        return INSTANCE;
    }

    @Override
    public Tracer createTracer(String string, String string2, String string3, TracingOptions tracingOptions) {
        TracingOptions tracingOptions2;
        Objects.requireNonNull(string, "'libraryName' cannot be null.");
        TracingOptions tracingOptions3 = tracingOptions2 = tracingOptions != null ? tracingOptions : DEFAULT_OPTIONS;
        if (tracingOptions2.isEnabled()) {
            return TRACER_PROVIDERS.create(tracerProvider -> tracerProvider.createTracer(string, string2, string3, tracingOptions2), FALLBACK_TRACER, tracingOptions2.getTracerProvider());
        }
        return NoopTracer.INSTANCE;
    }
}

