/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.util.serializer;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.TypeUtil;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;

public abstract class TypeReference<T> {
    private static final ClientLogger LOGGER = new ClientLogger(TypeReference.class);
    private static final String MISSING_TYPE = "Type constructed without type information.";
    private static final Map<Class<?>, TypeReference<?>> CACHE = new ConcurrentHashMap();
    private final Type javaType;
    private final Class<T> clazz;

    public TypeReference() {
        Type type = this.getClass().getGenericSuperclass();
        if (type instanceof Class) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(MISSING_TYPE));
        }
        this.javaType = ((ParameterizedType)type).getActualTypeArguments()[0];
        this.clazz = TypeUtil.getRawClass(this.javaType);
    }

    private TypeReference(Class<T> clazz) {
        this.javaType = clazz;
        this.clazz = clazz;
    }

    public Type getJavaType() {
        return this.javaType;
    }

    public static <T> TypeReference<T> createInstance(Class<T> clazz) {
        return CACHE.computeIfAbsent(clazz, clazz2 -> new TypeReference<T>(clazz){});
    }

    public Class<T> getJavaClass() {
        return this.clazz;
    }
}

