/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.implementation;

import java.net.URI;
import java.net.URISyntaxException;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.TypeUtil;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.BinaryData;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.serializer.ObjectSerializer;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.serializer.TypeReference;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;

public final class PollingUtils {
    private static final String FORWARD_SLASH = "/";

    public static Mono<BinaryData> serializeResponse(Object object, ObjectSerializer objectSerializer) {
        if (object instanceof BinaryData) {
            return Mono.just((Object)((BinaryData)object));
        }
        return BinaryData.fromObjectAsync(object, objectSerializer);
    }

    public static BinaryData serializeResponseSync(Object object, ObjectSerializer objectSerializer) {
        if (object instanceof BinaryData) {
            return (BinaryData)object;
        }
        return BinaryData.fromObject(object, objectSerializer);
    }

    public static <T> Mono<T> deserializeResponse(BinaryData binaryData, ObjectSerializer objectSerializer, TypeReference<T> typeReference) {
        if (TypeUtil.isTypeOrSubTypeOf(BinaryData.class, typeReference.getJavaType())) {
            return binaryData.toReplayableBinaryDataAsync();
        }
        return binaryData.toObjectAsync(typeReference, objectSerializer);
    }

    public static <T> T deserializeResponseSync(BinaryData binaryData, ObjectSerializer objectSerializer, TypeReference<T> typeReference) {
        if (TypeUtil.isTypeOrSubTypeOf(BinaryData.class, typeReference.getJavaType())) {
            return (T)binaryData.toReplayableBinaryData();
        }
        return binaryData.toObject(typeReference, objectSerializer);
    }

    public static <T> Mono<T> convertResponse(Object object, ObjectSerializer objectSerializer, TypeReference<T> typeReference) {
        if (object == null) {
            return Mono.empty();
        }
        if (TypeUtil.isTypeOrSubTypeOf(object.getClass(), typeReference.getJavaType())) {
            return Mono.just((Object)object);
        }
        return PollingUtils.serializeResponse(object, objectSerializer).flatMap(binaryData -> PollingUtils.deserializeResponse(binaryData, objectSerializer, typeReference));
    }

    public static <T> T convertResponseSync(Object object, ObjectSerializer objectSerializer, TypeReference<T> typeReference) {
        if (object == null) {
            return null;
        }
        if (TypeUtil.isTypeOrSubTypeOf(object.getClass(), typeReference.getJavaType())) {
            return (T)object;
        }
        return PollingUtils.deserializeResponseSync(PollingUtils.serializeResponseSync(object, objectSerializer), objectSerializer, typeReference);
    }

    public static String getAbsolutePath(String string, String string2, ClientLogger clientLogger) {
        try {
            URI uRI = new URI(string);
            if (!uRI.isAbsolute()) {
                if (CoreUtils.isNullOrEmpty(string2)) {
                    throw clientLogger.logExceptionAsError(new IllegalArgumentException("Relative path requires endpoint to be non-null and non-empty to create an absolute path."));
                }
                if (string2.endsWith(FORWARD_SLASH) && string.startsWith(FORWARD_SLASH)) {
                    return string2 + string.substring(1);
                }
                if (!string2.endsWith(FORWARD_SLASH) && !string.startsWith(FORWARD_SLASH)) {
                    return string2 + FORWARD_SLASH + string;
                }
                return string2 + string;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            throw clientLogger.logExceptionAsWarning(new IllegalArgumentException("'path' must be a valid URI.", uRISyntaxException));
        }
        return string;
    }

    private PollingUtils() {
    }
}

