/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling;

import java.time.Duration;
import java.time.OffsetDateTime;
import macromedia.jdbc.sqlserver.externals.com.azure.core.exception.AzureException;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.rest.Response;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.ImplUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.serializer.DefaultJsonSerializer;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.LongRunningOperationStatus;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.PollResponse;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.PollingContext;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.SyncPollingStrategy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.implementation.PollingUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.serializer.ObjectSerializer;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.serializer.TypeReference;

public class SyncStatusCheckPollingStrategy<T, U>
implements SyncPollingStrategy<T, U> {
    private static final ClientLogger LOGGER = new ClientLogger(SyncStatusCheckPollingStrategy.class);
    private static final ObjectSerializer DEFAULT_SERIALIZER = new DefaultJsonSerializer();
    private final ObjectSerializer serializer;

    public SyncStatusCheckPollingStrategy() {
        this(DEFAULT_SERIALIZER);
    }

    public SyncStatusCheckPollingStrategy(ObjectSerializer objectSerializer) {
        this.serializer = objectSerializer == null ? DEFAULT_SERIALIZER : objectSerializer;
    }

    @Override
    public boolean canPoll(Response<?> response) {
        return true;
    }

    @Override
    public PollResponse<T> onInitialResponse(Response<?> response, PollingContext<T> pollingContext, TypeReference<T> typeReference) {
        if (response.getStatusCode() == 200 || response.getStatusCode() == 201 || response.getStatusCode() == 202 || response.getStatusCode() == 204) {
            Duration duration = ImplUtils.getRetryAfterFromHeaders(response.getHeaders(), OffsetDateTime::now);
            return new PollResponse<T>(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, PollingUtils.convertResponseSync(response.getValue(), this.serializer, typeReference), duration);
        }
        throw LOGGER.logExceptionAsError(new AzureException("Operation failed or cancelled: " + response.getStatusCode()));
    }

    @Override
    public PollResponse<T> poll(PollingContext<T> pollingContext, TypeReference<T> typeReference) {
        throw LOGGER.logExceptionAsError(new IllegalStateException("StatusCheckPollingStrategy doesn't support polling"));
    }

    @Override
    public U getResult(PollingContext<T> pollingContext, TypeReference<U> typeReference) {
        T t2 = pollingContext.getActivationResponse().getValue();
        return PollingUtils.convertResponseSync(t2, this.serializer, typeReference);
    }
}

