/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling;

import java.net.MalformedURLException;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Function;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpHeader;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpHeaderName;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.rest.Response;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.ImplUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.SharedExecutorService;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.AsyncPollResponse;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.LongRunningOperationStatus;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.PollResponse;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.PollingContext;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.implementation.PollingUtils;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Flux;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;

class PollingUtil {
    private static final ClientLogger LOGGER = new ClientLogger(PollingUtil.class);

    PollingUtil() {
    }

    static <T> PollResponse<T> pollingLoop(PollingContext<T> pollingContext, Duration duration, LongRunningOperationStatus longRunningOperationStatus, Function<PollingContext<T>, PollResponse<T>> function, Duration duration2, boolean bl2) {
        boolean bl3 = duration != null;
        long l2 = bl3 ? duration.toMillis() : -1L;
        long l3 = System.currentTimeMillis();
        PollResponse pollResponse = pollingContext.getLatestResponse();
        boolean bl4 = true;
        while (!pollResponse.getStatus().isComplete()) {
            Future<PollResponse> future;
            long l4 = System.currentTimeMillis() - l3;
            if (bl3 && l4 >= l2) {
                if (pollResponse.getStatus().equals(longRunningOperationStatus) || bl2) {
                    return pollResponse;
                }
                throw LOGGER.logExceptionAsError(new RuntimeException(new TimeoutException("Polling didn't complete before the timeout period.")));
            }
            if (pollResponse.getStatus().equals(longRunningOperationStatus)) {
                return pollResponse;
            }
            if (bl4) {
                bl4 = false;
                future = SharedExecutorService.getInstance().submit(() -> (PollResponse)function.apply(pollingContext));
            } else {
                PollResponse pollResponse2 = pollResponse;
                future = SharedExecutorService.getInstance().submit(() -> {
                    Thread.sleep(PollingUtil.getDelay(pollResponse2, duration2).toMillis());
                    return (PollResponse)function.apply(pollingContext);
                });
            }
            try {
                long l5 = bl3 ? l2 - l4 : -1L;
                pollResponse = ImplUtils.getResultWithTimeout(future, l5);
                pollingContext.setLatestResponse(pollResponse);
            }
            catch (InterruptedException | ExecutionException | TimeoutException exception) {
                if (bl2) {
                    return pollResponse;
                }
                throw LOGGER.logExceptionAsError(new RuntimeException(exception));
            }
        }
        return pollResponse;
    }

    static <T, U> Flux<AsyncPollResponse<T, U>> pollingLoopAsync(PollingContext<T> pollingContext2, Function<PollingContext<T>, Mono<PollResponse<T>>> function, BiFunction<PollingContext<T>, PollResponse<T>, Mono<T>> biFunction, Function<PollingContext<T>, Mono<U>> function2, Duration duration) {
        return Flux.using(() -> pollingContext2, pollingContext -> Mono.defer(() -> (Mono)function.apply((PollingContext)pollingContext)).delaySubscription(PollingUtil.getDelay(pollingContext.getLatestResponse(), duration)).switchIfEmpty(Mono.error(() -> new IllegalStateException("PollOperation returned Mono.empty()."))).repeat().takeUntil(pollResponse -> pollResponse.getStatus().isComplete()).concatMap(pollResponse -> {
            pollingContext.setLatestResponse(pollResponse);
            return Mono.just(new AsyncPollResponse(pollingContext, biFunction, function2));
        }), pollingContext -> {});
    }

    private static <T> Duration getDelay(PollResponse<T> pollResponse, Duration duration) {
        Duration duration2 = pollResponse.getRetryAfter();
        if (duration2 == null) {
            return duration;
        }
        return duration2.compareTo(Duration.ZERO) > 0 ? duration2 : duration;
    }

    static <T, U> PollResponse<T> toPollResponse(AsyncPollResponse<T, U> asyncPollResponse) {
        return new PollResponse<T>(asyncPollResponse.getStatus(), asyncPollResponse.getValue(), asyncPollResponse.getRetryAfter());
    }

    static boolean matchStatus(AsyncPollResponse<?, ?> asyncPollResponse, LongRunningOperationStatus longRunningOperationStatus) {
        if (asyncPollResponse == null || longRunningOperationStatus == null) {
            return false;
        }
        return longRunningOperationStatus == asyncPollResponse.getStatus();
    }

    static boolean locationCanPoll(Response<?> response, String string, ClientLogger clientLogger) {
        HttpHeader httpHeader = response.getHeaders().get(HttpHeaderName.LOCATION);
        if (httpHeader != null) {
            try {
                ImplUtils.createUrl(PollingUtils.getAbsolutePath(httpHeader.getValue(), string, clientLogger));
                return true;
            }
            catch (MalformedURLException malformedURLException) {
                clientLogger.info("Failed to parse Location header into a URL.", malformedURLException);
                return false;
            }
        }
        return false;
    }

    static boolean operationResourceCanPoll(Response<?> response, HttpHeaderName httpHeaderName, String string, ClientLogger clientLogger) {
        HttpHeader httpHeader = response.getHeaders().get(httpHeaderName);
        if (httpHeader != null) {
            try {
                ImplUtils.createUrl(PollingUtils.getAbsolutePath(httpHeader.getValue(), string, clientLogger));
                return true;
            }
            catch (MalformedURLException malformedURLException) {
                return false;
            }
        }
        return false;
    }

    static void validateTimeout(Duration duration, ClientLogger clientLogger) {
        Objects.requireNonNull(duration, "'timeout' cannot be null.");
        if (duration.isNegative() || duration.isZero()) {
            throw clientLogger.logExceptionAsWarning(new IllegalArgumentException("Negative or zero value for timeout is not allowed."));
        }
    }

    static Duration validatePollInterval(Duration duration, ClientLogger clientLogger) {
        Objects.requireNonNull(duration, "'pollInterval' cannot be null.");
        if (duration.isNegative() || duration.isZero()) {
            throw clientLogger.logExceptionAsWarning(new IllegalArgumentException("Negative or zero value for pollInterval is not allowed."));
        }
        return duration;
    }
}

