/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.PollResponse;

public final class PollingContext<T> {
    private static final ClientLogger LOGGER = new ClientLogger(PollingContext.class);
    private final Map<String, String> map;
    private volatile PollResponse<T> activationResponse;
    private volatile PollResponse<T> latestResponse;

    public String getData(String string) {
        return this.map.get(string);
    }

    public PollingContext<T> setData(String string, String string2) {
        this.map.put(string, string2);
        return this;
    }

    public PollResponse<T> getActivationResponse() {
        return this.activationResponse;
    }

    public PollResponse<T> getLatestResponse() {
        return this.latestResponse;
    }

    void setLatestResponse(PollResponse<T> pollResponse) {
        this.latestResponse = Objects.requireNonNull(pollResponse, "'latestResponse' is required.");
    }

    void setOnetimeActivationResponse(PollResponse<T> pollResponse) {
        if (this.activationResponse != null) {
            throw LOGGER.logExceptionAsError(new IllegalStateException("setOnetimeActivationResponse can be called only once."));
        }
        this.activationResponse = pollResponse;
        this.latestResponse = this.activationResponse;
    }

    PollingContext<T> copy() {
        return new PollingContext<T>(this.activationResponse, this.latestResponse, new HashMap<String, String>(this.map));
    }

    PollingContext() {
        this.map = new HashMap<String, String>();
    }

    private PollingContext(PollResponse<T> pollResponse, PollResponse<T> pollResponse2, Map<String, String> map) {
        this.activationResponse = Objects.requireNonNull(pollResponse, "'activationResponse' cannot be null.");
        this.latestResponse = Objects.requireNonNull(pollResponse2, "'latestResponse' cannot be null.");
        this.map = map;
    }
}

