/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.rest.Response;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.FluxUtil;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.AsyncPollResponse;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.LongRunningOperationStatus;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.PollResponse;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.PollingContext;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.PollingStrategy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.SyncOverAsyncPoller;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.SyncPoller;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.serializer.TypeReference;
import macromedia.jdbc.sqlserver.externals.reactor.core.CoreSubscriber;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Flux;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;

public final class PollerFlux<T, U>
extends Flux<AsyncPollResponse<T, U>> {
    private static final ClientLogger LOGGER = new ClientLogger(PollerFlux.class);
    private final PollingContext<T> rootContext = new PollingContext();
    private final Function<PollingContext<T>, Mono<PollResponse<T>>> pollOperation;
    private final BiFunction<PollingContext<T>, PollResponse<T>, Mono<T>> cancelOperation;
    private final Function<PollingContext<T>, Mono<U>> fetchResultOperation;
    private final Mono<Boolean> oneTimeActivationMono;
    private final Function<PollingContext<T>, PollResponse<T>> syncActivationOperation;
    private volatile Duration pollInterval;

    public PollerFlux(Duration duration, Function<PollingContext<T>, Mono<T>> function, Function<PollingContext<T>, Mono<PollResponse<T>>> function2, BiFunction<PollingContext<T>, PollResponse<T>, Mono<T>> biFunction, Function<PollingContext<T>, Mono<U>> function3) {
        Objects.requireNonNull(duration, "'pollInterval' cannot be null.");
        if (duration.compareTo(Duration.ZERO) <= 0) {
            throw LOGGER.logExceptionAsWarning(new IllegalArgumentException("Negative or zero value for 'defaultPollInterval' is not allowed."));
        }
        this.pollInterval = duration;
        Objects.requireNonNull(function, "'activationOperation' cannot be null.");
        this.pollOperation = Objects.requireNonNull(function2, "'pollOperation' cannot be null.");
        this.cancelOperation = Objects.requireNonNull(biFunction, "'cancelOperation' cannot be null.");
        this.fetchResultOperation = Objects.requireNonNull(function3, "'fetchResultOperation' cannot be null.");
        this.oneTimeActivationMono = new OneTimeActivation<T, Object>(this.rootContext, function, object -> new PollResponse<Object>(LongRunningOperationStatus.NOT_STARTED, object)).getMono();
        this.syncActivationOperation = pollingContext -> new PollResponse<Object>(LongRunningOperationStatus.NOT_STARTED, ((Mono)function.apply(pollingContext)).block());
    }

    public static <T, U> PollerFlux<T, U> create(Duration duration, Function<PollingContext<T>, Mono<PollResponse<T>>> function, Function<PollingContext<T>, Mono<PollResponse<T>>> function2, BiFunction<PollingContext<T>, PollResponse<T>, Mono<T>> biFunction, Function<PollingContext<T>, Mono<U>> function3) {
        return new PollerFlux<T, U>(duration, function, function2, biFunction, function3, true);
    }

    public static <T, U> PollerFlux<T, U> create(Duration duration, Supplier<Mono<? extends Response<?>>> supplier, PollingStrategy<T, U> pollingStrategy, TypeReference<T> typeReference, TypeReference<U> typeReference2) {
        return PollerFlux.create(duration, (PollingContext<T> pollingContext) -> ((Mono)supplier.get()).flatMap(response -> pollingStrategy.canPoll((Response<?>)response).flatMap(bl2 -> {
            if (!bl2.booleanValue()) {
                return Mono.error((Throwable)new IllegalStateException("Cannot poll with strategy " + pollingStrategy.getClass().getSimpleName()));
            }
            return pollingStrategy.onInitialResponse((Response<?>)response, (PollingContext)pollingContext, typeReference);
        })), (PollingContext<T> pollingContext) -> pollingStrategy.poll((PollingContext)pollingContext, typeReference), pollingStrategy::cancel, (PollingContext<T> pollingContext) -> pollingStrategy.getResult((PollingContext)pollingContext, typeReference2));
    }

    private PollerFlux(Duration duration, Function<PollingContext<T>, Mono<PollResponse<T>>> function, Function<PollingContext<T>, Mono<PollResponse<T>>> function2, BiFunction<PollingContext<T>, PollResponse<T>, Mono<T>> biFunction, Function<PollingContext<T>, Mono<U>> function3, boolean bl2) {
        Objects.requireNonNull(duration, "'pollInterval' cannot be null.");
        if (duration.isNegative() || duration.isZero()) {
            throw LOGGER.logExceptionAsWarning(new IllegalArgumentException("Negative or zero value for 'pollInterval' is not allowed."));
        }
        this.pollInterval = duration;
        Objects.requireNonNull(function, "'activationOperation' cannot be null.");
        this.pollOperation = Objects.requireNonNull(function2, "'pollOperation' cannot be null.");
        this.cancelOperation = Objects.requireNonNull(biFunction, "'cancelOperation' cannot be null.");
        this.fetchResultOperation = Objects.requireNonNull(function3, "'fetchResultOperation' cannot be null.");
        this.oneTimeActivationMono = new OneTimeActivation(this.rootContext, function, Function.identity()).getMono();
        this.syncActivationOperation = pollingContext -> (PollResponse)((Mono)function.apply(pollingContext)).block();
    }

    public static <T, U> PollerFlux<T, U> error(Exception exception) {
        return new PollerFlux<T, U>(Duration.ofMillis(1L), pollingContext -> Mono.error((Throwable)exception), pollingContext -> Mono.error((Throwable)exception), (pollingContext, pollResponse) -> Mono.error((Throwable)exception), pollingContext -> Mono.error((Throwable)exception));
    }

    public PollerFlux<T, U> setPollInterval(Duration duration) {
        Objects.requireNonNull(duration, "'pollInterval' cannot be null.");
        if (duration.isNegative() || duration.isZero()) {
            throw LOGGER.logExceptionAsWarning(new IllegalArgumentException("Negative or zero value for 'pollInterval' is not allowed."));
        }
        this.pollInterval = duration;
        return this;
    }

    public Duration getPollInterval() {
        return this.pollInterval;
    }

    public void subscribe(CoreSubscriber<? super AsyncPollResponse<T, U>> coreSubscriber) {
        this.oneTimeActivationMono.flatMapMany(bl2 -> {
            PollResponse<T> pollResponse = this.rootContext.getActivationResponse();
            if (pollResponse.getStatus().isComplete()) {
                return Flux.just(new AsyncPollResponse<T, U>(this.rootContext, this.cancelOperation, this.fetchResultOperation));
            }
            return this.pollingLoop();
        }).subscribe(coreSubscriber);
    }

    public SyncPoller<T, U> getSyncPoller() {
        return new SyncOverAsyncPoller<T, U>(this.pollInterval, this.syncActivationOperation, this.pollOperation, this.cancelOperation, this.fetchResultOperation);
    }

    private Flux<AsyncPollResponse<T, U>> pollingLoop() {
        return Flux.using(() -> this.rootContext.copy(), pollingContext -> Mono.defer(() -> {
            Mono<PollResponse<T>> mono = this.pollOperation.apply((PollingContext<PollingContext>)pollingContext);
            return mono.delaySubscription(this.getDelay(pollingContext.getLatestResponse()));
        }).switchIfEmpty(Mono.error(() -> new IllegalStateException("PollOperation returned Mono.empty()."))).repeat().takeUntil(pollResponse -> pollResponse.getStatus().isComplete()).concatMap(pollResponse -> {
            pollingContext.setLatestResponse(pollResponse);
            return Mono.just(new AsyncPollResponse<T, U>(pollingContext, this.cancelOperation, this.fetchResultOperation));
        }), pollingContext -> {});
    }

    private Duration getDelay(PollResponse<T> pollResponse) {
        Duration duration = pollResponse.getRetryAfter();
        return duration == null || duration.isNegative() || duration.isZero() ? this.pollInterval : duration;
    }

    private static final class OneTimeActivation<V, R> {
        private final PollingContext<V> rootContext;
        private final Function<PollingContext<V>, Mono<R>> activationFunction;
        private final Function<R, PollResponse<V>> activationPollResponseMapper;
        private volatile boolean activated = false;
        private final AtomicBoolean guardActivation = new AtomicBoolean(false);

        OneTimeActivation(PollingContext<V> pollingContext, Function<PollingContext<V>, Mono<R>> function, Function<R, PollResponse<V>> function2) {
            this.rootContext = pollingContext;
            this.activationFunction = function;
            this.activationPollResponseMapper = function2;
        }

        Mono<Boolean> getMono() {
            return Mono.defer(() -> {
                if (this.activated) {
                    return Mono.just((Object)true);
                }
                if (this.guardActivation.compareAndSet(false, true)) {
                    Mono<R> mono;
                    try {
                        mono = this.activationFunction.apply(this.rootContext);
                    }
                    catch (RuntimeException runtimeException) {
                        this.guardActivation.set(false);
                        return FluxUtil.monoError(LOGGER, runtimeException);
                    }
                    return mono.map(this.activationPollResponseMapper).switchIfEmpty(Mono.fromSupplier(() -> new PollResponse<Object>(LongRunningOperationStatus.NOT_STARTED, null))).map(pollResponse -> {
                        this.rootContext.setOnetimeActivationResponse((PollResponse<V>)pollResponse);
                        this.activated = true;
                        return true;
                    }).doOnError(throwable -> this.guardActivation.set(false));
                }
                return Mono.empty();
            }).repeatWhenEmpty(flux -> flux.concatMap(l2 -> Flux.just((Object)true)));
        }
    }
}

