/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling;

import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.azure.core.exception.AzureException;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpHeader;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpHeaderName;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpMethod;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpPipeline;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpRequest;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpResponse;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.rest.Response;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.ImplUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.serializer.DefaultJsonSerializer;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.BinaryData;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.Context;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.FluxUtil;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.UrlBuilder;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.LongRunningOperationStatus;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.PollResponse;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.PollingContext;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.PollingStrategy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.PollingStrategyOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.PollingUtil;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.implementation.PollResult;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.implementation.PollingUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.serializer.ObjectSerializer;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.serializer.TypeReference;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;

public class OperationResourcePollingStrategy<T, U>
implements PollingStrategy<T, U> {
    private static final ClientLogger LOGGER = new ClientLogger(OperationResourcePollingStrategy.class);
    private static final HttpHeaderName DEFAULT_OPERATION_LOCATION_HEADER = HttpHeaderName.fromString("Operation-Location");
    private static final TypeReference<PollResult> POLL_RESULT_TYPE_REFERENCE = TypeReference.createInstance(PollResult.class);
    private final HttpPipeline httpPipeline;
    private final ObjectSerializer serializer;
    private final String endpoint;
    private final HttpHeaderName operationLocationHeaderName;
    private final Context context;
    private final String serviceVersion;

    public OperationResourcePollingStrategy(HttpPipeline httpPipeline) {
        this(DEFAULT_OPERATION_LOCATION_HEADER, new PollingStrategyOptions(httpPipeline));
    }

    public OperationResourcePollingStrategy(HttpPipeline httpPipeline, ObjectSerializer objectSerializer, String string) {
        this(httpPipeline, objectSerializer, string, Context.NONE);
    }

    public OperationResourcePollingStrategy(HttpPipeline httpPipeline, ObjectSerializer objectSerializer, String string, Context context) {
        this(httpPipeline, null, objectSerializer, string, context);
    }

    public OperationResourcePollingStrategy(HttpPipeline httpPipeline, String string, ObjectSerializer objectSerializer, String string2, Context context) {
        this(string2 == null ? null : HttpHeaderName.fromString(string2), new PollingStrategyOptions(httpPipeline).setEndpoint(string).setSerializer(objectSerializer).setContext(context));
    }

    public OperationResourcePollingStrategy(HttpHeaderName httpHeaderName, PollingStrategyOptions pollingStrategyOptions) {
        Objects.requireNonNull(pollingStrategyOptions, "'pollingStrategyOptions' cannot be null");
        this.httpPipeline = pollingStrategyOptions.getHttpPipeline();
        this.endpoint = pollingStrategyOptions.getEndpoint();
        this.serializer = pollingStrategyOptions.getSerializer() != null ? pollingStrategyOptions.getSerializer() : new DefaultJsonSerializer();
        this.operationLocationHeaderName = httpHeaderName == null ? DEFAULT_OPERATION_LOCATION_HEADER : httpHeaderName;
        this.serviceVersion = pollingStrategyOptions.getServiceVersion();
        this.context = pollingStrategyOptions.getContext() == null ? Context.NONE : pollingStrategyOptions.getContext();
    }

    @Override
    public Mono<Boolean> canPoll(Response<?> response) {
        return Mono.fromSupplier(() -> PollingUtil.operationResourceCanPoll(response, this.operationLocationHeaderName, this.endpoint, LOGGER));
    }

    @Override
    public Mono<PollResponse<T>> onInitialResponse(Response<?> response, PollingContext<T> pollingContext, TypeReference<T> typeReference) {
        HttpHeader httpHeader = response.getHeaders().get(this.operationLocationHeaderName);
        HttpHeader httpHeader2 = response.getHeaders().get(HttpHeaderName.LOCATION);
        if (httpHeader != null) {
            pollingContext.setData(this.operationLocationHeaderName.getCaseSensitiveName(), PollingUtils.getAbsolutePath(httpHeader.getValue(), this.endpoint, LOGGER));
        }
        if (httpHeader2 != null) {
            pollingContext.setData("Location", PollingUtils.getAbsolutePath(httpHeader2.getValue(), this.endpoint, LOGGER));
        }
        pollingContext.setData("httpMethod", response.getRequest().getHttpMethod().name());
        pollingContext.setData("requestURL", response.getRequest().getUrl().toString());
        if (response.getStatusCode() == 200 || response.getStatusCode() == 201 || response.getStatusCode() == 202 || response.getStatusCode() == 204) {
            Duration duration = ImplUtils.getRetryAfterFromHeaders(response.getHeaders(), OffsetDateTime::now);
            return PollingUtils.convertResponse(response.getValue(), this.serializer, typeReference).map(object -> new PollResponse<Object>(LongRunningOperationStatus.IN_PROGRESS, object, duration)).switchIfEmpty(Mono.fromSupplier(() -> new PollResponse<Object>(LongRunningOperationStatus.IN_PROGRESS, null, duration)));
        }
        return Mono.error((Throwable)new AzureException(String.format("Operation failed or cancelled with status code %d,, '%s' header: %s, and response body: %s", response.getStatusCode(), this.operationLocationHeaderName, httpHeader, PollingUtils.serializeResponse(response.getValue(), this.serializer))));
    }

    @Override
    public Mono<PollResponse<T>> poll(PollingContext<T> pollingContext, TypeReference<T> typeReference) {
        String string = pollingContext.getData(this.operationLocationHeaderName.getCaseSensitiveName());
        string = this.setServiceVersionQueryParam(string);
        HttpRequest httpRequest = new HttpRequest(HttpMethod.GET, string);
        return FluxUtil.withContext(context -> this.httpPipeline.send(httpRequest, CoreUtils.mergeContexts(context, this.context))).flatMap(httpResponse -> httpResponse.getBodyAsByteArray().map(BinaryData::fromBytes).flatMap(binaryData -> PollingUtils.deserializeResponse(binaryData, this.serializer, POLL_RESULT_TYPE_REFERENCE).map(pollResult -> {
            String string = pollResult.getResourceLocation();
            if (string != null) {
                pollingContext.setData("resourceLocation", PollingUtils.getAbsolutePath(string, this.endpoint, LOGGER));
            }
            pollingContext.setData("pollResponseBody", binaryData.toString());
            return pollResult.getStatus();
        }).flatMap(longRunningOperationStatus -> {
            Duration duration = ImplUtils.getRetryAfterFromHeaders(httpResponse.getHeaders(), OffsetDateTime::now);
            return PollingUtils.deserializeResponse(binaryData, this.serializer, typeReference).map(object -> new PollResponse<Object>((LongRunningOperationStatus)longRunningOperationStatus, object, duration));
        })));
    }

    private String setServiceVersionQueryParam(String string) {
        if (!CoreUtils.isNullOrEmpty(this.serviceVersion)) {
            UrlBuilder urlBuilder = UrlBuilder.parse(string);
            urlBuilder.setQueryParameter("api-version", this.serviceVersion);
            string = urlBuilder.toString();
        }
        return string;
    }

    @Override
    public Mono<U> getResult(PollingContext<T> pollingContext, TypeReference<U> typeReference) {
        Object object;
        if (pollingContext.getLatestResponse().getStatus() == LongRunningOperationStatus.FAILED) {
            return Mono.error((Throwable)new AzureException("Long running operation failed."));
        }
        if (pollingContext.getLatestResponse().getStatus() == LongRunningOperationStatus.USER_CANCELLED) {
            return Mono.error((Throwable)new AzureException("Long running operation cancelled."));
        }
        String string = pollingContext.getData("resourceLocation");
        if (string == null) {
            object = pollingContext.getData("httpMethod");
            if (HttpMethod.PUT.name().equalsIgnoreCase((String)object) || HttpMethod.PATCH.name().equalsIgnoreCase((String)object)) {
                string = pollingContext.getData("requestURL");
            } else if (HttpMethod.POST.name().equalsIgnoreCase((String)object)) {
                string = pollingContext.getData("Location");
            } else {
                return Mono.error((Throwable)new AzureException("Cannot get final result"));
            }
        }
        if (string == null) {
            object = pollingContext.getData("pollResponseBody");
            return PollingUtils.deserializeResponse(BinaryData.fromString((String)object), this.serializer, typeReference);
        }
        string = this.setServiceVersionQueryParam(string);
        object = new HttpRequest(HttpMethod.GET, string);
        return FluxUtil.withContext(arg_0 -> this.lambda$getResult$9((HttpRequest)object, arg_0)).flatMap(HttpResponse::getBodyAsByteArray).map(BinaryData::fromBytes).flatMap(binaryData -> PollingUtils.deserializeResponse(binaryData, this.serializer, typeReference));
    }

    private /* synthetic */ Mono lambda$getResult$9(HttpRequest httpRequest, Context context) {
        return this.httpPipeline.send(httpRequest, CoreUtils.mergeContexts(context, this.context));
    }
}

