/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.rest.Response;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.PollResponse;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.PollingContext;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.PollingStrategy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.serializer.TypeReference;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Flux;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;
import macromedia.jdbc.sqlserver.externals.reactor.util.function.Tuple2;
import macromedia.jdbc.sqlserver.externals.reactor.util.function.Tuples;

public final class ChainedPollingStrategy<T, U>
implements PollingStrategy<T, U> {
    private static final ClientLogger LOGGER = new ClientLogger(ChainedPollingStrategy.class);
    private final List<PollingStrategy<T, U>> pollingStrategies;
    private PollingStrategy<T, U> pollableStrategy = null;

    public ChainedPollingStrategy(List<PollingStrategy<T, U>> list) {
        Objects.requireNonNull(list, "'strategies' cannot be null.");
        if (list.isEmpty()) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'strategies' cannot be empty."));
        }
        this.pollingStrategies = Collections.unmodifiableList(list);
    }

    @Override
    public Mono<Boolean> canPoll(Response<?> response) {
        return Flux.fromIterable(this.pollingStrategies).concatMap(pollingStrategy -> pollingStrategy.canPoll(response).map(bl2 -> Tuples.of((Object)pollingStrategy, (Object)bl2))).takeUntil(Tuple2::getT2).last().map(tuple2 -> {
            this.pollableStrategy = (PollingStrategy)tuple2.getT1();
            return true;
        }).defaultIfEmpty((Object)false);
    }

    @Override
    public Mono<U> getResult(PollingContext<T> pollingContext, TypeReference<U> typeReference) {
        return this.pollableStrategy.getResult(pollingContext, typeReference);
    }

    @Override
    public Mono<PollResponse<T>> onInitialResponse(Response<?> response, PollingContext<T> pollingContext, TypeReference<T> typeReference) {
        return this.pollableStrategy.onInitialResponse(response, pollingContext, typeReference);
    }

    @Override
    public Mono<PollResponse<T>> poll(PollingContext<T> pollingContext, TypeReference<T> typeReference) {
        return this.pollableStrategy.poll(pollingContext, typeReference);
    }

    @Override
    public Mono<T> cancel(PollingContext<T> pollingContext, PollResponse<T> pollResponse) {
        return this.pollableStrategy.cancel(pollingContext, pollResponse);
    }
}

