/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.util.paging;

import java.util.Iterator;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.IterableStream;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.paging.ContinuablePage;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.paging.ContinuablePagedByItemIterable;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.paging.ContinuablePagedByPageIterable;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.paging.ContinuablePagedFlux;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.paging.ContinuablePagedFluxCore;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.paging.PageRetrieverSync;

public class ContinuablePagedIterable<C, T, P extends ContinuablePage<C, T>>
extends IterableStream<T> {
    private static final ClientLogger LOGGER = new ClientLogger(ContinuablePagedIterable.class);
    private final ContinuablePagedFlux<C, T, P> pagedFlux;
    private final int batchSize;
    private final Supplier<PageRetrieverSync<C, P>> pageRetrieverSyncProvider;
    final Integer defaultPageSize;
    private final Predicate<C> continuationPredicate;

    public ContinuablePagedIterable(ContinuablePagedFlux<C, T, P> continuablePagedFlux) {
        this(continuablePagedFlux, 1);
    }

    public ContinuablePagedIterable(ContinuablePagedFlux<C, T, P> continuablePagedFlux, int n2) {
        super(continuablePagedFlux);
        this.pagedFlux = continuablePagedFlux;
        this.batchSize = n2;
        this.defaultPageSize = null;
        this.continuationPredicate = null;
        this.pageRetrieverSyncProvider = null;
    }

    public ContinuablePagedIterable(Supplier<PageRetrieverSync<C, P>> supplier, Integer n2, Predicate<C> predicate) {
        super(new ContinuablePagedByItemIterable(supplier.get(), null, predicate, n2));
        this.pageRetrieverSyncProvider = Objects.requireNonNull(supplier, "'pageRetrieverSyncProvider' function cannot be null.");
        if (n2 != null && n2 <= 0) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'pageSize' must be greater than 0 required but provided: " + n2));
        }
        this.continuationPredicate = predicate == null ? Objects::nonNull : predicate;
        this.defaultPageSize = n2;
        this.batchSize = 1;
        this.pagedFlux = null;
    }

    @Override
    public Stream<T> stream() {
        return StreamSupport.stream(this.iterableByItemInternal().spliterator(), false);
    }

    public Stream<P> streamByPage() {
        return this.streamByPageInternal(null, null, () -> this.pagedFlux.byPage().toStream(this.batchSize));
    }

    public Stream<P> streamByPage(C c2) {
        return this.streamByPageInternal(c2, null, () -> this.pagedFlux.byPage(c2).toStream(this.batchSize));
    }

    public Stream<P> streamByPage(int n2) {
        return this.streamByPageInternal(null, n2, () -> this.pagedFlux.byPage(n2).toStream(this.batchSize));
    }

    public Stream<P> streamByPage(C c2, int n2) {
        return this.streamByPageInternal(c2, n2, () -> this.pagedFlux.byPage(c2, n2).toStream(this.batchSize));
    }

    @Override
    public Iterator<T> iterator() {
        return this.iterableByItemInternal().iterator();
    }

    public Iterable<P> iterableByPage() {
        return this.iterableByPageInternal(null, null, () -> this.pagedFlux.byPage().toIterable(this.batchSize));
    }

    public Iterable<P> iterableByPage(C c2) {
        return this.iterableByPageInternal(c2, null, () -> this.pagedFlux.byPage(c2).toIterable(this.batchSize));
    }

    public Iterable<P> iterableByPage(int n2) {
        return this.iterableByPageInternal(null, n2, () -> this.pagedFlux.byPage(n2).toIterable(this.batchSize));
    }

    public Iterable<P> iterableByPage(C c2, int n2) {
        return this.iterableByPageInternal(c2, n2, () -> this.pagedFlux.byPage(c2, n2).toIterable(this.batchSize));
    }

    private Stream<P> streamByPageInternal(C c2, Integer n2, Supplier<Stream<P>> supplier) {
        if (this.pagedFlux == null) {
            return StreamSupport.stream(this.iterableByPageInternal(c2, n2, null).spliterator(), false);
        }
        if (this.pagedFlux instanceof ContinuablePagedFluxCore) {
            return StreamSupport.stream(this.iterableByPageInternal(c2, n2, null).spliterator(), false);
        }
        return supplier.get();
    }

    private Iterable<P> iterableByPageInternal(C c2, Integer n2, Supplier<Iterable<P>> supplier) {
        if (this.pagedFlux == null) {
            return new ContinuablePagedByPageIterable(this.pageRetrieverSyncProvider.get(), c2, this.continuationPredicate, n2);
        }
        if (this.pagedFlux instanceof ContinuablePagedFluxCore) {
            ContinuablePagedFluxCore continuablePagedFluxCore = (ContinuablePagedFluxCore)this.pagedFlux;
            return new ContinuablePagedByPageIterable(continuablePagedFluxCore.pageRetrieverProvider.get(), c2, continuablePagedFluxCore.getContinuationPredicate(), n2);
        }
        return supplier.get();
    }

    private Iterable<T> iterableByItemInternal() {
        if (this.pagedFlux == null) {
            return new ContinuablePagedByItemIterable(this.pageRetrieverSyncProvider.get(), null, this.continuationPredicate, null);
        }
        if (this.pagedFlux instanceof ContinuablePagedFluxCore) {
            ContinuablePagedFluxCore continuablePagedFluxCore = (ContinuablePagedFluxCore)this.pagedFlux;
            return new ContinuablePagedByItemIterable(continuablePagedFluxCore.pageRetrieverProvider.get(), null, continuablePagedFluxCore.getContinuationPredicate(), null);
        }
        return this.pagedFlux.toIterable(this.batchSize);
    }
}

