/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.util.paging;

import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Predicate;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.paging.ContinuablePage;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.paging.ContinuablePagedByIteratorBase;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.paging.ContinuationState;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.paging.PageRetriever;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.paging.PageRetrieverSync;

final class ContinuablePagedByPageIterable<C, T, P extends ContinuablePage<C, T>>
implements Iterable<P> {
    private final PageRetriever<C, P> pageRetriever;
    private final PageRetrieverSync<C, P> pageRetrieverSync;
    private final C continuationToken;
    private final Predicate<C> continuationPredicate;
    private final Integer preferredPageSize;

    ContinuablePagedByPageIterable(PageRetriever<C, P> pageRetriever, C c2, Predicate<C> predicate, Integer n2) {
        this.pageRetriever = pageRetriever;
        this.continuationToken = c2;
        this.continuationPredicate = predicate;
        this.preferredPageSize = n2;
        this.pageRetrieverSync = null;
    }

    ContinuablePagedByPageIterable(PageRetrieverSync<C, P> pageRetrieverSync, C c2, Predicate<C> predicate, Integer n2) {
        this.pageRetrieverSync = pageRetrieverSync;
        this.continuationToken = c2;
        this.continuationPredicate = predicate;
        this.preferredPageSize = n2;
        this.pageRetriever = null;
    }

    @Override
    public Iterator<P> iterator() {
        if (this.pageRetriever != null) {
            return new ContinuablePagedByPageIterator(this.pageRetriever, this.continuationToken, this.continuationPredicate, this.preferredPageSize);
        }
        return new ContinuablePagedByPageIterator(this.pageRetrieverSync, this.continuationToken, this.continuationPredicate, this.preferredPageSize);
    }

    private static final class ContinuablePagedByPageIterator<C, T, P extends ContinuablePage<C, T>>
    extends ContinuablePagedByIteratorBase<C, T, P, P> {
        private static final ClientLogger LOGGER = new ClientLogger(ContinuablePagedByPageIterator.class);
        private volatile Queue<P> pages = new ConcurrentLinkedQueue<P>();

        ContinuablePagedByPageIterator(PageRetriever<C, P> pageRetriever, C c2, Predicate<C> predicate, Integer n2) {
            super(pageRetriever, new ContinuationState<C>(c2, predicate), n2, LOGGER);
            this.requestPage();
        }

        ContinuablePagedByPageIterator(PageRetrieverSync<C, P> pageRetrieverSync, C c2, Predicate<C> predicate, Integer n2) {
            super(pageRetrieverSync, new ContinuationState<C>(c2, predicate), n2, LOGGER);
            this.requestPage();
        }

        @Override
        boolean needToRequestPage() {
            return this.pages.peek() == null;
        }

        @Override
        public boolean isNextAvailable() {
            return this.pages.peek() != null;
        }

        @Override
        P getNext() {
            return (P)((ContinuablePage)this.pages.poll());
        }

        @Override
        void addPage(P p2) {
            this.pages.add(p2);
        }
    }
}

