/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging;

import java.util.HashMap;
import java.util.Locale;

public enum LogLevel {
    VERBOSE(1, "1", "verbose", "debug"),
    INFORMATIONAL(2, "2", "info", "information", "informational"),
    WARNING(3, "3", "warn", "warning"),
    ERROR(4, "4", "err", "error"),
    NOT_SET(5, "5");

    private final int numericValue;
    private final String[] allowedLogLevelVariables;
    private static final HashMap<String, LogLevel> LOG_LEVEL_STRING_MAPPER;

    private LogLevel(int n3, String ... stringArray) {
        this.numericValue = n3;
        this.allowedLogLevelVariables = stringArray;
    }

    public int getLogLevel() {
        return this.numericValue;
    }

    public static LogLevel fromString(String string) {
        if (string == null) {
            return NOT_SET;
        }
        String string2 = string.toLowerCase(Locale.ROOT);
        if (!LOG_LEVEL_STRING_MAPPER.containsKey(string2)) {
            throw new IllegalArgumentException("We currently do not support the log level you set. LogLevel: " + string);
        }
        return LOG_LEVEL_STRING_MAPPER.get(string2);
    }

    static {
        LOG_LEVEL_STRING_MAPPER = new HashMap();
        for (LogLevel logLevel : LogLevel.values()) {
            for (String string : logLevel.allowedLogLevelVariables) {
                LOG_LEVEL_STRING_MAPPER.put(string, logLevel);
            }
        }
    }
}

